// Generated by rstantools.  Do not edit by hand.

/*
    glmmfields is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    glmmfields is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with glmmfields.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_glmmfields_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_glmmfields");
    reader.add_event(273, 271, "end", "model_glmmfields");
    return reader;
}
#include <stan_meta_header.hpp>
class model_glmmfields
  : public stan::model::model_base_crtp<model_glmmfields> {
private:
        int nKnots;
        int nLocs;
        int nT;
        int N;
        std::vector<int> stationID;
        std::vector<int> yearID;
        std::vector<int> binomialN;
        std::vector<double> y;
        std::vector<int> y_int;
        std::vector<double> offset;
        std::vector<double> prior_gp_theta;
        std::vector<double> prior_gp_sigma;
        std::vector<double> prior_sigma;
        std::vector<double> prior_rw_sigma;
        std::vector<double> prior_intercept;
        std::vector<double> prior_beta;
        std::vector<double> prior_phi;
        matrix_d distKnots;
        matrix_d distKnots21;
        int nCov;
        matrix_d X;
        int cov_func;
        int est_df;
        int est_phi;
        int norm_params;
        int gamma_params;
        int nb2_params;
        int obs_model;
        double fixed_df_value;
        double fixed_phi_value;
        int est_temporalRE;
        int n_year_effects;
        int lower_truncation;
        int fixed_intercept;
        double matern_kappa;
        int nW;
        double gp_sigma_scaling_factor;
        double df_lower_bound;
public:
    model_glmmfields(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_glmmfields(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_glmmfields_namespace::model_glmmfields";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 2;
            context__.validate_dims("data initialization", "nKnots", "int", context__.to_vec());
            nKnots = int(0);
            vals_i__ = context__.vals_i("nKnots");
            pos__ = 0;
            nKnots = vals_i__[pos__++];
            check_greater_or_equal(function__, "nKnots", nKnots, 1);
            current_statement_begin__ = 3;
            context__.validate_dims("data initialization", "nLocs", "int", context__.to_vec());
            nLocs = int(0);
            vals_i__ = context__.vals_i("nLocs");
            pos__ = 0;
            nLocs = vals_i__[pos__++];
            check_greater_or_equal(function__, "nLocs", nLocs, 1);
            current_statement_begin__ = 4;
            context__.validate_dims("data initialization", "nT", "int", context__.to_vec());
            nT = int(0);
            vals_i__ = context__.vals_i("nT");
            pos__ = 0;
            nT = vals_i__[pos__++];
            check_greater_or_equal(function__, "nT", nT, 1);
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 1);
            current_statement_begin__ = 6;
            validate_non_negative_index("stationID", "N", N);
            context__.validate_dims("data initialization", "stationID", "int", context__.to_vec(N));
            stationID = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("stationID");
            pos__ = 0;
            size_t stationID_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < stationID_k_0_max__; ++k_0__) {
                stationID[k_0__] = vals_i__[pos__++];
            }
            size_t stationID_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < stationID_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "stationID[i_0__]", stationID[i_0__], 1);
            }
            current_statement_begin__ = 7;
            validate_non_negative_index("yearID", "N", N);
            context__.validate_dims("data initialization", "yearID", "int", context__.to_vec(N));
            yearID = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("yearID");
            pos__ = 0;
            size_t yearID_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < yearID_k_0_max__; ++k_0__) {
                yearID[k_0__] = vals_i__[pos__++];
            }
            size_t yearID_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < yearID_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "yearID[i_0__]", yearID[i_0__], 1);
            }
            current_statement_begin__ = 8;
            validate_non_negative_index("binomialN", "N", N);
            context__.validate_dims("data initialization", "binomialN", "int", context__.to_vec(N));
            binomialN = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("binomialN");
            pos__ = 0;
            size_t binomialN_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < binomialN_k_0_max__; ++k_0__) {
                binomialN[k_0__] = vals_i__[pos__++];
            }
            size_t binomialN_i_0_max__ = N;
            for (size_t i_0__ = 0; i_0__ < binomialN_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "binomialN[i_0__]", binomialN[i_0__], 0);
            }
            current_statement_begin__ = 9;
            validate_non_negative_index("y", "N", N);
            context__.validate_dims("data initialization", "y", "double", context__.to_vec(N));
            y = std::vector<double>(N, double(0));
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < y_k_0_max__; ++k_0__) {
                y[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 10;
            validate_non_negative_index("y_int", "N", N);
            context__.validate_dims("data initialization", "y_int", "int", context__.to_vec(N));
            y_int = std::vector<int>(N, int(0));
            vals_i__ = context__.vals_i("y_int");
            pos__ = 0;
            size_t y_int_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < y_int_k_0_max__; ++k_0__) {
                y_int[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 11;
            validate_non_negative_index("offset", "N", N);
            context__.validate_dims("data initialization", "offset", "double", context__.to_vec(N));
            offset = std::vector<double>(N, double(0));
            vals_r__ = context__.vals_r("offset");
            pos__ = 0;
            size_t offset_k_0_max__ = N;
            for (size_t k_0__ = 0; k_0__ < offset_k_0_max__; ++k_0__) {
                offset[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 12;
            validate_non_negative_index("prior_gp_theta", "3", 3);
            context__.validate_dims("data initialization", "prior_gp_theta", "double", context__.to_vec(3));
            prior_gp_theta = std::vector<double>(3, double(0));
            vals_r__ = context__.vals_r("prior_gp_theta");
            pos__ = 0;
            size_t prior_gp_theta_k_0_max__ = 3;
            for (size_t k_0__ = 0; k_0__ < prior_gp_theta_k_0_max__; ++k_0__) {
                prior_gp_theta[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 13;
            validate_non_negative_index("prior_gp_sigma", "3", 3);
            context__.validate_dims("data initialization", "prior_gp_sigma", "double", context__.to_vec(3));
            prior_gp_sigma = std::vector<double>(3, double(0));
            vals_r__ = context__.vals_r("prior_gp_sigma");
            pos__ = 0;
            size_t prior_gp_sigma_k_0_max__ = 3;
            for (size_t k_0__ = 0; k_0__ < prior_gp_sigma_k_0_max__; ++k_0__) {
                prior_gp_sigma[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 14;
            validate_non_negative_index("prior_sigma", "3", 3);
            context__.validate_dims("data initialization", "prior_sigma", "double", context__.to_vec(3));
            prior_sigma = std::vector<double>(3, double(0));
            vals_r__ = context__.vals_r("prior_sigma");
            pos__ = 0;
            size_t prior_sigma_k_0_max__ = 3;
            for (size_t k_0__ = 0; k_0__ < prior_sigma_k_0_max__; ++k_0__) {
                prior_sigma[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 15;
            validate_non_negative_index("prior_rw_sigma", "3", 3);
            context__.validate_dims("data initialization", "prior_rw_sigma", "double", context__.to_vec(3));
            prior_rw_sigma = std::vector<double>(3, double(0));
            vals_r__ = context__.vals_r("prior_rw_sigma");
            pos__ = 0;
            size_t prior_rw_sigma_k_0_max__ = 3;
            for (size_t k_0__ = 0; k_0__ < prior_rw_sigma_k_0_max__; ++k_0__) {
                prior_rw_sigma[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 16;
            validate_non_negative_index("prior_intercept", "3", 3);
            context__.validate_dims("data initialization", "prior_intercept", "double", context__.to_vec(3));
            prior_intercept = std::vector<double>(3, double(0));
            vals_r__ = context__.vals_r("prior_intercept");
            pos__ = 0;
            size_t prior_intercept_k_0_max__ = 3;
            for (size_t k_0__ = 0; k_0__ < prior_intercept_k_0_max__; ++k_0__) {
                prior_intercept[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 17;
            validate_non_negative_index("prior_beta", "3", 3);
            context__.validate_dims("data initialization", "prior_beta", "double", context__.to_vec(3));
            prior_beta = std::vector<double>(3, double(0));
            vals_r__ = context__.vals_r("prior_beta");
            pos__ = 0;
            size_t prior_beta_k_0_max__ = 3;
            for (size_t k_0__ = 0; k_0__ < prior_beta_k_0_max__; ++k_0__) {
                prior_beta[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 18;
            validate_non_negative_index("prior_phi", "3", 3);
            context__.validate_dims("data initialization", "prior_phi", "double", context__.to_vec(3));
            prior_phi = std::vector<double>(3, double(0));
            vals_r__ = context__.vals_r("prior_phi");
            pos__ = 0;
            size_t prior_phi_k_0_max__ = 3;
            for (size_t k_0__ = 0; k_0__ < prior_phi_k_0_max__; ++k_0__) {
                prior_phi[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 19;
            validate_non_negative_index("distKnots", "nKnots", nKnots);
            validate_non_negative_index("distKnots", "nKnots", nKnots);
            context__.validate_dims("data initialization", "distKnots", "matrix_d", context__.to_vec(nKnots,nKnots));
            distKnots = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nKnots, nKnots);
            vals_r__ = context__.vals_r("distKnots");
            pos__ = 0;
            size_t distKnots_j_2_max__ = nKnots;
            size_t distKnots_j_1_max__ = nKnots;
            for (size_t j_2__ = 0; j_2__ < distKnots_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < distKnots_j_1_max__; ++j_1__) {
                    distKnots(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 20;
            validate_non_negative_index("distKnots21", "nLocs", nLocs);
            validate_non_negative_index("distKnots21", "nKnots", nKnots);
            context__.validate_dims("data initialization", "distKnots21", "matrix_d", context__.to_vec(nLocs,nKnots));
            distKnots21 = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nLocs, nKnots);
            vals_r__ = context__.vals_r("distKnots21");
            pos__ = 0;
            size_t distKnots21_j_2_max__ = nKnots;
            size_t distKnots21_j_1_max__ = nLocs;
            for (size_t j_2__ = 0; j_2__ < distKnots21_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < distKnots21_j_1_max__; ++j_1__) {
                    distKnots21(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 21;
            context__.validate_dims("data initialization", "nCov", "int", context__.to_vec());
            nCov = int(0);
            vals_i__ = context__.vals_i("nCov");
            pos__ = 0;
            nCov = vals_i__[pos__++];
            check_greater_or_equal(function__, "nCov", nCov, 0);
            current_statement_begin__ = 22;
            validate_non_negative_index("X", "N", N);
            validate_non_negative_index("X", "nCov", nCov);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(N,nCov));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, nCov);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = nCov;
            size_t X_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 23;
            context__.validate_dims("data initialization", "cov_func", "int", context__.to_vec());
            cov_func = int(0);
            vals_i__ = context__.vals_i("cov_func");
            pos__ = 0;
            cov_func = vals_i__[pos__++];
            check_greater_or_equal(function__, "cov_func", cov_func, 0);
            check_less_or_equal(function__, "cov_func", cov_func, 2);
            current_statement_begin__ = 24;
            context__.validate_dims("data initialization", "est_df", "int", context__.to_vec());
            est_df = int(0);
            vals_i__ = context__.vals_i("est_df");
            pos__ = 0;
            est_df = vals_i__[pos__++];
            check_greater_or_equal(function__, "est_df", est_df, 0);
            check_less_or_equal(function__, "est_df", est_df, 1);
            current_statement_begin__ = 25;
            context__.validate_dims("data initialization", "est_phi", "int", context__.to_vec());
            est_phi = int(0);
            vals_i__ = context__.vals_i("est_phi");
            pos__ = 0;
            est_phi = vals_i__[pos__++];
            check_greater_or_equal(function__, "est_phi", est_phi, 0);
            check_less_or_equal(function__, "est_phi", est_phi, 1);
            current_statement_begin__ = 26;
            context__.validate_dims("data initialization", "norm_params", "int", context__.to_vec());
            norm_params = int(0);
            vals_i__ = context__.vals_i("norm_params");
            pos__ = 0;
            norm_params = vals_i__[pos__++];
            check_greater_or_equal(function__, "norm_params", norm_params, 0);
            check_less_or_equal(function__, "norm_params", norm_params, 1);
            current_statement_begin__ = 27;
            context__.validate_dims("data initialization", "gamma_params", "int", context__.to_vec());
            gamma_params = int(0);
            vals_i__ = context__.vals_i("gamma_params");
            pos__ = 0;
            gamma_params = vals_i__[pos__++];
            check_greater_or_equal(function__, "gamma_params", gamma_params, 0);
            check_less_or_equal(function__, "gamma_params", gamma_params, 1);
            current_statement_begin__ = 28;
            context__.validate_dims("data initialization", "nb2_params", "int", context__.to_vec());
            nb2_params = int(0);
            vals_i__ = context__.vals_i("nb2_params");
            pos__ = 0;
            nb2_params = vals_i__[pos__++];
            check_greater_or_equal(function__, "nb2_params", nb2_params, 0);
            check_less_or_equal(function__, "nb2_params", nb2_params, 1);
            current_statement_begin__ = 29;
            context__.validate_dims("data initialization", "obs_model", "int", context__.to_vec());
            obs_model = int(0);
            vals_i__ = context__.vals_i("obs_model");
            pos__ = 0;
            obs_model = vals_i__[pos__++];
            check_greater_or_equal(function__, "obs_model", obs_model, 0);
            check_less_or_equal(function__, "obs_model", obs_model, 6);
            current_statement_begin__ = 30;
            context__.validate_dims("data initialization", "fixed_df_value", "double", context__.to_vec());
            fixed_df_value = double(0);
            vals_r__ = context__.vals_r("fixed_df_value");
            pos__ = 0;
            fixed_df_value = vals_r__[pos__++];
            check_greater_or_equal(function__, "fixed_df_value", fixed_df_value, 1);
            current_statement_begin__ = 31;
            context__.validate_dims("data initialization", "fixed_phi_value", "double", context__.to_vec());
            fixed_phi_value = double(0);
            vals_r__ = context__.vals_r("fixed_phi_value");
            pos__ = 0;
            fixed_phi_value = vals_r__[pos__++];
            current_statement_begin__ = 32;
            context__.validate_dims("data initialization", "est_temporalRE", "int", context__.to_vec());
            est_temporalRE = int(0);
            vals_i__ = context__.vals_i("est_temporalRE");
            pos__ = 0;
            est_temporalRE = vals_i__[pos__++];
            check_greater_or_equal(function__, "est_temporalRE", est_temporalRE, 0);
            check_less_or_equal(function__, "est_temporalRE", est_temporalRE, 1);
            current_statement_begin__ = 33;
            context__.validate_dims("data initialization", "n_year_effects", "int", context__.to_vec());
            n_year_effects = int(0);
            vals_i__ = context__.vals_i("n_year_effects");
            pos__ = 0;
            n_year_effects = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_year_effects", n_year_effects, 0);
            current_statement_begin__ = 34;
            context__.validate_dims("data initialization", "lower_truncation", "int", context__.to_vec());
            lower_truncation = int(0);
            vals_i__ = context__.vals_i("lower_truncation");
            pos__ = 0;
            lower_truncation = vals_i__[pos__++];
            check_greater_or_equal(function__, "lower_truncation", lower_truncation, 0);
            current_statement_begin__ = 35;
            context__.validate_dims("data initialization", "fixed_intercept", "int", context__.to_vec());
            fixed_intercept = int(0);
            vals_i__ = context__.vals_i("fixed_intercept");
            pos__ = 0;
            fixed_intercept = vals_i__[pos__++];
            check_greater_or_equal(function__, "fixed_intercept", fixed_intercept, 0);
            check_less_or_equal(function__, "fixed_intercept", fixed_intercept, 1);
            current_statement_begin__ = 36;
            context__.validate_dims("data initialization", "matern_kappa", "double", context__.to_vec());
            matern_kappa = double(0);
            vals_r__ = context__.vals_r("matern_kappa");
            pos__ = 0;
            matern_kappa = vals_r__[pos__++];
            current_statement_begin__ = 37;
            context__.validate_dims("data initialization", "nW", "int", context__.to_vec());
            nW = int(0);
            vals_i__ = context__.vals_i("nW");
            pos__ = 0;
            nW = vals_i__[pos__++];
            check_greater_or_equal(function__, "nW", nW, 0);
            check_less_or_equal(function__, "nW", nW, nT);
            current_statement_begin__ = 38;
            context__.validate_dims("data initialization", "gp_sigma_scaling_factor", "double", context__.to_vec());
            gp_sigma_scaling_factor = double(0);
            vals_r__ = context__.vals_r("gp_sigma_scaling_factor");
            pos__ = 0;
            gp_sigma_scaling_factor = vals_r__[pos__++];
            check_greater_or_equal(function__, "gp_sigma_scaling_factor", gp_sigma_scaling_factor, 0);
            current_statement_begin__ = 39;
            context__.validate_dims("data initialization", "df_lower_bound", "double", context__.to_vec());
            df_lower_bound = double(0);
            vals_r__ = context__.vals_r("df_lower_bound");
            pos__ = 0;
            df_lower_bound = vals_r__[pos__++];
            check_greater_or_equal(function__, "df_lower_bound", df_lower_bound, 1);
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 42;
            num_params_r__ += 1;
            current_statement_begin__ = 43;
            num_params_r__ += 1;
            current_statement_begin__ = 44;
            validate_non_negative_index("df", "est_df", est_df);
            num_params_r__ += (1 * est_df);
            current_statement_begin__ = 45;
            validate_non_negative_index("sigma", "norm_params", norm_params);
            num_params_r__ += (1 * norm_params);
            current_statement_begin__ = 46;
            validate_non_negative_index("CV", "gamma_params", gamma_params);
            num_params_r__ += (1 * gamma_params);
            current_statement_begin__ = 47;
            validate_non_negative_index("nb2_phi", "nb2_params", nb2_params);
            num_params_r__ += (1 * nb2_params);
            current_statement_begin__ = 48;
            validate_non_negative_index("yearEffects", "n_year_effects", n_year_effects);
            num_params_r__ += (1 * n_year_effects);
            current_statement_begin__ = 49;
            validate_non_negative_index("year_sigma", "est_temporalRE", est_temporalRE);
            num_params_r__ += (1 * est_temporalRE);
            current_statement_begin__ = 50;
            validate_non_negative_index("spatialEffectsKnots", "nKnots", nKnots);
            validate_non_negative_index("spatialEffectsKnots", "nT", nT);
            num_params_r__ += (nKnots * nT);
            current_statement_begin__ = 51;
            validate_non_negative_index("B", "nCov", nCov);
            num_params_r__ += nCov;
            current_statement_begin__ = 52;
            validate_non_negative_index("phi", "est_phi", est_phi);
            num_params_r__ += (1 * est_phi);
            current_statement_begin__ = 53;
            validate_non_negative_index("W", "nW", nW);
            num_params_r__ += (1 * nW);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_glmmfields() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 42;
        if (!(context__.contains_r("gp_theta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gp_theta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gp_theta");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "gp_theta", "double", context__.to_vec());
        double gp_theta(0);
        gp_theta = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, gp_theta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gp_theta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 43;
        if (!(context__.contains_r("gp_sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gp_sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gp_sigma");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "gp_sigma", "double", context__.to_vec());
        double gp_sigma(0);
        gp_sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0, gp_sigma);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gp_sigma: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 44;
        if (!(context__.contains_r("df")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable df missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("df");
        pos__ = 0U;
        validate_non_negative_index("df", "est_df", est_df);
        context__.validate_dims("parameter initialization", "df", "double", context__.to_vec(est_df));
        std::vector<double> df(est_df, double(0));
        size_t df_k_0_max__ = est_df;
        for (size_t k_0__ = 0; k_0__ < df_k_0_max__; ++k_0__) {
            df[k_0__] = vals_r__[pos__++];
        }
        size_t df_i_0_max__ = est_df;
        for (size_t i_0__ = 0; i_0__ < df_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(df_lower_bound, df[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable df: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 45;
        if (!(context__.contains_r("sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "norm_params", norm_params);
        context__.validate_dims("parameter initialization", "sigma", "double", context__.to_vec(norm_params));
        std::vector<double> sigma(norm_params, double(0));
        size_t sigma_k_0_max__ = norm_params;
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            sigma[k_0__] = vals_r__[pos__++];
        }
        size_t sigma_i_0_max__ = norm_params;
        for (size_t i_0__ = 0; i_0__ < sigma_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, sigma[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigma: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 46;
        if (!(context__.contains_r("CV")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable CV missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("CV");
        pos__ = 0U;
        validate_non_negative_index("CV", "gamma_params", gamma_params);
        context__.validate_dims("parameter initialization", "CV", "double", context__.to_vec(gamma_params));
        std::vector<double> CV(gamma_params, double(0));
        size_t CV_k_0_max__ = gamma_params;
        for (size_t k_0__ = 0; k_0__ < CV_k_0_max__; ++k_0__) {
            CV[k_0__] = vals_r__[pos__++];
        }
        size_t CV_i_0_max__ = gamma_params;
        for (size_t i_0__ = 0; i_0__ < CV_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, CV[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable CV: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 47;
        if (!(context__.contains_r("nb2_phi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable nb2_phi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("nb2_phi");
        pos__ = 0U;
        validate_non_negative_index("nb2_phi", "nb2_params", nb2_params);
        context__.validate_dims("parameter initialization", "nb2_phi", "double", context__.to_vec(nb2_params));
        std::vector<double> nb2_phi(nb2_params, double(0));
        size_t nb2_phi_k_0_max__ = nb2_params;
        for (size_t k_0__ = 0; k_0__ < nb2_phi_k_0_max__; ++k_0__) {
            nb2_phi[k_0__] = vals_r__[pos__++];
        }
        size_t nb2_phi_i_0_max__ = nb2_params;
        for (size_t i_0__ = 0; i_0__ < nb2_phi_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, nb2_phi[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable nb2_phi: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 48;
        if (!(context__.contains_r("yearEffects")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable yearEffects missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("yearEffects");
        pos__ = 0U;
        validate_non_negative_index("yearEffects", "n_year_effects", n_year_effects);
        context__.validate_dims("parameter initialization", "yearEffects", "double", context__.to_vec(n_year_effects));
        std::vector<double> yearEffects(n_year_effects, double(0));
        size_t yearEffects_k_0_max__ = n_year_effects;
        for (size_t k_0__ = 0; k_0__ < yearEffects_k_0_max__; ++k_0__) {
            yearEffects[k_0__] = vals_r__[pos__++];
        }
        size_t yearEffects_i_0_max__ = n_year_effects;
        for (size_t i_0__ = 0; i_0__ < yearEffects_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_unconstrain(yearEffects[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable yearEffects: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 49;
        if (!(context__.contains_r("year_sigma")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable year_sigma missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("year_sigma");
        pos__ = 0U;
        validate_non_negative_index("year_sigma", "est_temporalRE", est_temporalRE);
        context__.validate_dims("parameter initialization", "year_sigma", "double", context__.to_vec(est_temporalRE));
        std::vector<double> year_sigma(est_temporalRE, double(0));
        size_t year_sigma_k_0_max__ = est_temporalRE;
        for (size_t k_0__ = 0; k_0__ < year_sigma_k_0_max__; ++k_0__) {
            year_sigma[k_0__] = vals_r__[pos__++];
        }
        size_t year_sigma_i_0_max__ = est_temporalRE;
        for (size_t i_0__ = 0; i_0__ < year_sigma_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, year_sigma[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable year_sigma: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 50;
        if (!(context__.contains_r("spatialEffectsKnots")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable spatialEffectsKnots missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("spatialEffectsKnots");
        pos__ = 0U;
        validate_non_negative_index("spatialEffectsKnots", "nKnots", nKnots);
        validate_non_negative_index("spatialEffectsKnots", "nT", nT);
        context__.validate_dims("parameter initialization", "spatialEffectsKnots", "vector_d", context__.to_vec(nT,nKnots));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > spatialEffectsKnots(nT, Eigen::Matrix<double, Eigen::Dynamic, 1>(nKnots));
        size_t spatialEffectsKnots_j_1_max__ = nKnots;
        size_t spatialEffectsKnots_k_0_max__ = nT;
        for (size_t j_1__ = 0; j_1__ < spatialEffectsKnots_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < spatialEffectsKnots_k_0_max__; ++k_0__) {
                spatialEffectsKnots[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t spatialEffectsKnots_i_0_max__ = nT;
        for (size_t i_0__ = 0; i_0__ < spatialEffectsKnots_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(spatialEffectsKnots[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable spatialEffectsKnots: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 51;
        if (!(context__.contains_r("B")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable B missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("B");
        pos__ = 0U;
        validate_non_negative_index("B", "nCov", nCov);
        context__.validate_dims("parameter initialization", "B", "vector_d", context__.to_vec(nCov));
        Eigen::Matrix<double, Eigen::Dynamic, 1> B(nCov);
        size_t B_j_1_max__ = nCov;
        for (size_t j_1__ = 0; j_1__ < B_j_1_max__; ++j_1__) {
            B(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(B);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable B: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 52;
        if (!(context__.contains_r("phi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable phi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        validate_non_negative_index("phi", "est_phi", est_phi);
        context__.validate_dims("parameter initialization", "phi", "double", context__.to_vec(est_phi));
        std::vector<double> phi(est_phi, double(0));
        size_t phi_k_0_max__ = est_phi;
        for (size_t k_0__ = 0; k_0__ < phi_k_0_max__; ++k_0__) {
            phi[k_0__] = vals_r__[pos__++];
        }
        size_t phi_i_0_max__ = est_phi;
        for (size_t i_0__ = 0; i_0__ < phi_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lub_unconstrain(-(1), 1, phi[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable phi: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 53;
        if (!(context__.contains_r("W")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable W missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("W");
        pos__ = 0U;
        validate_non_negative_index("W", "nW", nW);
        context__.validate_dims("parameter initialization", "W", "double", context__.to_vec(nW));
        std::vector<double> W(nW, double(0));
        size_t W_k_0_max__ = nW;
        for (size_t k_0__ = 0; k_0__ < W_k_0_max__; ++k_0__) {
            W[k_0__] = vals_r__[pos__++];
        }
        size_t W_i_0_max__ = nW;
        for (size_t i_0__ = 0; i_0__ < W_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, W[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable W: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 42;
            local_scalar_t__ gp_theta;
            (void) gp_theta;  // dummy to suppress unused var warning
            if (jacobian__)
                gp_theta = in__.scalar_lb_constrain(0, lp__);
            else
                gp_theta = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 43;
            local_scalar_t__ gp_sigma;
            (void) gp_sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                gp_sigma = in__.scalar_lb_constrain(0, lp__);
            else
                gp_sigma = in__.scalar_lb_constrain(0);
            current_statement_begin__ = 44;
            std::vector<local_scalar_t__> df;
            size_t df_d_0_max__ = est_df;
            df.reserve(df_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < df_d_0_max__; ++d_0__) {
                if (jacobian__)
                    df.push_back(in__.scalar_lb_constrain(df_lower_bound, lp__));
                else
                    df.push_back(in__.scalar_lb_constrain(df_lower_bound));
            }
            current_statement_begin__ = 45;
            std::vector<local_scalar_t__> sigma;
            size_t sigma_d_0_max__ = norm_params;
            sigma.reserve(sigma_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < sigma_d_0_max__; ++d_0__) {
                if (jacobian__)
                    sigma.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    sigma.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 46;
            std::vector<local_scalar_t__> CV;
            size_t CV_d_0_max__ = gamma_params;
            CV.reserve(CV_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < CV_d_0_max__; ++d_0__) {
                if (jacobian__)
                    CV.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    CV.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 47;
            std::vector<local_scalar_t__> nb2_phi;
            size_t nb2_phi_d_0_max__ = nb2_params;
            nb2_phi.reserve(nb2_phi_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < nb2_phi_d_0_max__; ++d_0__) {
                if (jacobian__)
                    nb2_phi.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    nb2_phi.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 48;
            std::vector<local_scalar_t__> yearEffects;
            size_t yearEffects_d_0_max__ = n_year_effects;
            yearEffects.reserve(yearEffects_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < yearEffects_d_0_max__; ++d_0__) {
                if (jacobian__)
                    yearEffects.push_back(in__.scalar_constrain(lp__));
                else
                    yearEffects.push_back(in__.scalar_constrain());
            }
            current_statement_begin__ = 49;
            std::vector<local_scalar_t__> year_sigma;
            size_t year_sigma_d_0_max__ = est_temporalRE;
            year_sigma.reserve(year_sigma_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < year_sigma_d_0_max__; ++d_0__) {
                if (jacobian__)
                    year_sigma.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    year_sigma.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 50;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > spatialEffectsKnots;
            size_t spatialEffectsKnots_d_0_max__ = nT;
            spatialEffectsKnots.reserve(spatialEffectsKnots_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < spatialEffectsKnots_d_0_max__; ++d_0__) {
                if (jacobian__)
                    spatialEffectsKnots.push_back(in__.vector_constrain(nKnots, lp__));
                else
                    spatialEffectsKnots.push_back(in__.vector_constrain(nKnots));
            }
            current_statement_begin__ = 51;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> B;
            (void) B;  // dummy to suppress unused var warning
            if (jacobian__)
                B = in__.vector_constrain(nCov, lp__);
            else
                B = in__.vector_constrain(nCov);
            current_statement_begin__ = 52;
            std::vector<local_scalar_t__> phi;
            size_t phi_d_0_max__ = est_phi;
            phi.reserve(phi_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < phi_d_0_max__; ++d_0__) {
                if (jacobian__)
                    phi.push_back(in__.scalar_lub_constrain(-(1), 1, lp__));
                else
                    phi.push_back(in__.scalar_lub_constrain(-(1), 1));
            }
            current_statement_begin__ = 53;
            std::vector<local_scalar_t__> W;
            size_t W_d_0_max__ = nW;
            W.reserve(W_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < W_d_0_max__; ++d_0__) {
                if (jacobian__)
                    W.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    W.push_back(in__.scalar_lb_constrain(0));
            }
            // transformed parameters
            current_statement_begin__ = 56;
            validate_non_negative_index("muZeros", "nKnots", nKnots);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> muZeros(nKnots);
            stan::math::initialize(muZeros, DUMMY_VAR__);
            stan::math::fill(muZeros, DUMMY_VAR__);
            current_statement_begin__ = 57;
            validate_non_negative_index("spatialEffects", "nLocs", nLocs);
            validate_non_negative_index("spatialEffects", "nT", nT);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > spatialEffects(nT, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(nLocs));
            stan::math::initialize(spatialEffects, DUMMY_VAR__);
            stan::math::fill(spatialEffects, DUMMY_VAR__);
            current_statement_begin__ = 58;
            validate_non_negative_index("SigmaKnots", "nKnots", nKnots);
            validate_non_negative_index("SigmaKnots", "nKnots", nKnots);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> SigmaKnots(nKnots, nKnots);
            stan::math::initialize(SigmaKnots, DUMMY_VAR__);
            stan::math::fill(SigmaKnots, DUMMY_VAR__);
            current_statement_begin__ = 59;
            validate_non_negative_index("transformed_dist", "nKnots", nKnots);
            validate_non_negative_index("transformed_dist", "nKnots", nKnots);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> transformed_dist(nKnots, nKnots);
            stan::math::initialize(transformed_dist, DUMMY_VAR__);
            stan::math::fill(transformed_dist, DUMMY_VAR__);
            current_statement_begin__ = 60;
            validate_non_negative_index("transformed_dist21", "nLocs", nLocs);
            validate_non_negative_index("transformed_dist21", "nKnots", nKnots);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> transformed_dist21(nLocs, nKnots);
            stan::math::initialize(transformed_dist21, DUMMY_VAR__);
            stan::math::fill(transformed_dist21, DUMMY_VAR__);
            current_statement_begin__ = 61;
            validate_non_negative_index("SigmaOffDiag", "nLocs", nLocs);
            validate_non_negative_index("SigmaOffDiag", "nKnots", nKnots);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> SigmaOffDiag(nLocs, nKnots);
            stan::math::initialize(SigmaOffDiag, DUMMY_VAR__);
            stan::math::fill(SigmaOffDiag, DUMMY_VAR__);
            current_statement_begin__ = 62;
            validate_non_negative_index("SigmaOffDiagTemp", "nLocs", nLocs);
            validate_non_negative_index("SigmaOffDiagTemp", "nKnots", nKnots);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> SigmaOffDiagTemp(nLocs, nKnots);
            stan::math::initialize(SigmaOffDiagTemp, DUMMY_VAR__);
            stan::math::fill(SigmaOffDiagTemp, DUMMY_VAR__);
            current_statement_begin__ = 63;
            validate_non_negative_index("invSigmaKnots", "nLocs", nLocs);
            validate_non_negative_index("invSigmaKnots", "nKnots", nKnots);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> invSigmaKnots(nLocs, nKnots);
            stan::math::initialize(invSigmaKnots, DUMMY_VAR__);
            stan::math::fill(invSigmaKnots, DUMMY_VAR__);
            current_statement_begin__ = 64;
            validate_non_negative_index("y_hat", "N", N);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> y_hat(N);
            stan::math::initialize(y_hat, DUMMY_VAR__);
            stan::math::fill(y_hat, DUMMY_VAR__);
            current_statement_begin__ = 65;
            validate_non_negative_index("gammaA", "gamma_params", gamma_params);
            std::vector<local_scalar_t__> gammaA(gamma_params, local_scalar_t__(0));
            stan::math::initialize(gammaA, DUMMY_VAR__);
            stan::math::fill(gammaA, DUMMY_VAR__);
            current_statement_begin__ = 66;
            local_scalar_t__ gp_sigma_sq;
            (void) gp_sigma_sq;  // dummy to suppress unused var warning
            stan::math::initialize(gp_sigma_sq, DUMMY_VAR__);
            stan::math::fill(gp_sigma_sq, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 67;
            stan::math::assign(gp_sigma_sq, pow((gp_sigma * gp_sigma_scaling_factor), 2.0));
            current_statement_begin__ = 70;
            if (as_bool(logical_eq(cov_func, 0))) {
                current_statement_begin__ = 72;
                stan::math::assign(SigmaKnots, multiply(gp_sigma_sq, stan::math::exp(divide(minus(distKnots), gp_theta))));
                current_statement_begin__ = 74;
                stan::math::assign(SigmaOffDiagTemp, multiply(gp_sigma_sq, stan::math::exp(divide(minus(distKnots21), gp_theta))));
            }
            current_statement_begin__ = 76;
            if (as_bool(logical_eq(cov_func, 1))) {
                current_statement_begin__ = 78;
                stan::math::assign(SigmaKnots, multiply(gp_sigma_sq, stan::math::exp(multiply(-(inv((2.0 * pow(gp_theta, 2.0)))), distKnots))));
                current_statement_begin__ = 81;
                stan::math::assign(SigmaOffDiagTemp, multiply(gp_sigma_sq, stan::math::exp(multiply(-(inv((2.0 * pow(gp_theta, 2.0)))), distKnots21))));
            }
            current_statement_begin__ = 84;
            if (as_bool(logical_eq(cov_func, 2))) {
                current_statement_begin__ = 85;
                if (as_bool(logical_eq(matern_kappa, 1.5))) {
                    current_statement_begin__ = 87;
                    stan::math::assign(transformed_dist, divide(multiply(stan::math::sqrt(3.0), distKnots), gp_theta));
                    current_statement_begin__ = 88;
                    stan::math::assign(SigmaKnots, elt_multiply(multiply(gp_sigma_sq, add(1.0, transformed_dist)), stan::math::exp(minus(transformed_dist))));
                    current_statement_begin__ = 90;
                    stan::math::assign(transformed_dist21, divide(multiply(stan::math::sqrt(3.0), distKnots21), gp_theta));
                    current_statement_begin__ = 91;
                    stan::math::assign(SigmaOffDiagTemp, elt_multiply(multiply(gp_sigma_sq, add(1.0, transformed_dist21)), stan::math::exp(minus(transformed_dist21))));
                }
                current_statement_begin__ = 93;
                if (as_bool(logical_eq(matern_kappa, 2.5))) {
                    current_statement_begin__ = 95;
                    stan::math::assign(transformed_dist, divide(multiply(stan::math::sqrt(5.0), distKnots), gp_theta));
                    current_statement_begin__ = 96;
                    stan::math::assign(SigmaKnots, elt_multiply(multiply(gp_sigma_sq, add(add(1.0, transformed_dist), divide(elt_multiply(transformed_dist, transformed_dist), 3.0))), stan::math::exp(minus(transformed_dist))));
                    current_statement_begin__ = 99;
                    stan::math::assign(transformed_dist21, divide(multiply(stan::math::sqrt(5.0), distKnots21), gp_theta));
                    current_statement_begin__ = 100;
                    stan::math::assign(SigmaOffDiagTemp, elt_multiply(multiply(gp_sigma_sq, add(add(1.0, transformed_dist21), divide(elt_multiply(transformed_dist21, transformed_dist21), 3.0))), stan::math::exp(minus(transformed_dist21))));
                }
            }
            current_statement_begin__ = 105;
            for (int k = 1; k <= nKnots; ++k) {
                current_statement_begin__ = 106;
                stan::model::assign(muZeros, 
                            stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable muZeros");
            }
            current_statement_begin__ = 109;
            stan::math::assign(SigmaOffDiag, multiply(SigmaOffDiagTemp, inverse_spd(SigmaKnots)));
            current_statement_begin__ = 110;
            for (int t = 1; t <= nT; ++t) {
                current_statement_begin__ = 111;
                stan::model::assign(spatialEffects, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            multiply(SigmaOffDiag, get_base1(spatialEffectsKnots, t, "spatialEffectsKnots", 1)), 
                            "assigning variable spatialEffects");
            }
            current_statement_begin__ = 115;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 116;
                if (as_bool(logical_eq(est_temporalRE, 0))) {
                    current_statement_begin__ = 117;
                    if (as_bool(logical_eq(fixed_intercept, 0))) {
                        current_statement_begin__ = 118;
                        stan::model::assign(y_hat, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (multiply(get_base1(X, i, "X", 1), B) + get_base1(get_base1(spatialEffects, get_base1(yearID, i, "yearID", 1), "spatialEffects", 1), get_base1(stationID, i, "stationID", 1), "spatialEffects", 2)), 
                                    "assigning variable y_hat");
                    } else {
                        current_statement_begin__ = 120;
                        stan::model::assign(y_hat, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    get_base1(get_base1(spatialEffects, get_base1(yearID, i, "yearID", 1), "spatialEffects", 1), get_base1(stationID, i, "stationID", 1), "spatialEffects", 2), 
                                    "assigning variable y_hat");
                    }
                } else {
                    current_statement_begin__ = 123;
                    if (as_bool(logical_eq(nCov, 0))) {
                        current_statement_begin__ = 124;
                        stan::model::assign(y_hat, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(get_base1(spatialEffects, get_base1(yearID, i, "yearID", 1), "spatialEffects", 1), get_base1(stationID, i, "stationID", 1), "spatialEffects", 2) + get_base1(yearEffects, get_base1(yearID, i, "yearID", 1), "yearEffects", 1)), 
                                    "assigning variable y_hat");
                    }
                    current_statement_begin__ = 126;
                    if (as_bool(logical_gt(nCov, 0))) {
                        current_statement_begin__ = 127;
                        stan::model::assign(y_hat, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((multiply(get_base1(X, i, "X", 1), B) + get_base1(get_base1(spatialEffects, get_base1(yearID, i, "yearID", 1), "spatialEffects", 1), get_base1(stationID, i, "stationID", 1), "spatialEffects", 2)) + get_base1(yearEffects, get_base1(yearID, i, "yearID", 1), "yearEffects", 1)), 
                                    "assigning variable y_hat");
                    }
                }
                current_statement_begin__ = 130;
                stan::model::assign(y_hat, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(y_hat, i, "y_hat", 1) + get_base1(offset, i, "offset", 1)), 
                            "assigning variable y_hat");
            }
            current_statement_begin__ = 133;
            if (as_bool(logical_eq(obs_model, 0))) {
                current_statement_begin__ = 134;
                stan::model::assign(gammaA, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            inv(pow(get_base1(CV, 1, "CV", 1), 2.0)), 
                            "assigning variable gammaA");
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 56;
            size_t muZeros_j_1_max__ = nKnots;
            for (size_t j_1__ = 0; j_1__ < muZeros_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(muZeros(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: muZeros" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable muZeros: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 57;
            size_t spatialEffects_k_0_max__ = nT;
            size_t spatialEffects_j_1_max__ = nLocs;
            for (size_t k_0__ = 0; k_0__ < spatialEffects_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < spatialEffects_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(spatialEffects[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: spatialEffects" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable spatialEffects: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 58;
            size_t SigmaKnots_j_1_max__ = nKnots;
            size_t SigmaKnots_j_2_max__ = nKnots;
            for (size_t j_1__ = 0; j_1__ < SigmaKnots_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < SigmaKnots_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(SigmaKnots(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: SigmaKnots" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable SigmaKnots: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 59;
            size_t transformed_dist_j_1_max__ = nKnots;
            size_t transformed_dist_j_2_max__ = nKnots;
            for (size_t j_1__ = 0; j_1__ < transformed_dist_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < transformed_dist_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(transformed_dist(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: transformed_dist" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable transformed_dist: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 60;
            size_t transformed_dist21_j_1_max__ = nLocs;
            size_t transformed_dist21_j_2_max__ = nKnots;
            for (size_t j_1__ = 0; j_1__ < transformed_dist21_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < transformed_dist21_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(transformed_dist21(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: transformed_dist21" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable transformed_dist21: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 61;
            size_t SigmaOffDiag_j_1_max__ = nLocs;
            size_t SigmaOffDiag_j_2_max__ = nKnots;
            for (size_t j_1__ = 0; j_1__ < SigmaOffDiag_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < SigmaOffDiag_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(SigmaOffDiag(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: SigmaOffDiag" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable SigmaOffDiag: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 62;
            size_t SigmaOffDiagTemp_j_1_max__ = nLocs;
            size_t SigmaOffDiagTemp_j_2_max__ = nKnots;
            for (size_t j_1__ = 0; j_1__ < SigmaOffDiagTemp_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < SigmaOffDiagTemp_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(SigmaOffDiagTemp(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: SigmaOffDiagTemp" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable SigmaOffDiagTemp: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 63;
            size_t invSigmaKnots_j_1_max__ = nLocs;
            size_t invSigmaKnots_j_2_max__ = nKnots;
            for (size_t j_1__ = 0; j_1__ < invSigmaKnots_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < invSigmaKnots_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(invSigmaKnots(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: invSigmaKnots" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable invSigmaKnots: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 64;
            size_t y_hat_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < y_hat_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(y_hat(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: y_hat" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable y_hat: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 65;
            size_t gammaA_k_0_max__ = gamma_params;
            for (size_t k_0__ = 0; k_0__ < gammaA_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(gammaA[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: gammaA" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable gammaA: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            size_t gammaA_i_0_max__ = gamma_params;
            for (size_t i_0__ = 0; i_0__ < gammaA_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "gammaA[i_0__]", gammaA[i_0__], 0);
            }
            current_statement_begin__ = 66;
            if (stan::math::is_uninitialized(gp_sigma_sq)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: gp_sigma_sq";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable gp_sigma_sq: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            check_greater_or_equal(function__, "gp_sigma_sq", gp_sigma_sq, 0);
            // model body
            current_statement_begin__ = 139;
            lp_accum__.add(student_t_log<propto__>(gp_theta, get_base1(prior_gp_theta, 1, "prior_gp_theta", 1), get_base1(prior_gp_theta, 2, "prior_gp_theta", 1), get_base1(prior_gp_theta, 3, "prior_gp_theta", 1)));
            current_statement_begin__ = 140;
            lp_accum__.add(student_t_log<propto__>(gp_sigma, get_base1(prior_gp_sigma, 1, "prior_gp_sigma", 1), get_base1(prior_gp_sigma, 2, "prior_gp_sigma", 1), get_base1(prior_gp_sigma, 3, "prior_gp_sigma", 1)));
            current_statement_begin__ = 142;
            if (as_bool(logical_eq(est_phi, 1))) {
                current_statement_begin__ = 143;
                lp_accum__.add(student_t_log<propto__>(phi, get_base1(prior_phi, 1, "prior_phi", 1), get_base1(prior_phi, 2, "prior_phi", 1), get_base1(prior_phi, 3, "prior_phi", 1)));
            }
            current_statement_begin__ = 146;
            if (as_bool(logical_gte(nCov, 1))) {
                current_statement_begin__ = 148;
                lp_accum__.add(student_t_log<propto__>(get_base1(B, 1, "B", 1), get_base1(prior_intercept, 1, "prior_intercept", 1), get_base1(prior_intercept, 2, "prior_intercept", 1), get_base1(prior_intercept, 3, "prior_intercept", 1)));
            }
            current_statement_begin__ = 150;
            if (as_bool(logical_gte(nCov, 2))) {
                current_statement_begin__ = 151;
                for (int i = 2; i <= nCov; ++i) {
                    current_statement_begin__ = 153;
                    lp_accum__.add(student_t_log<propto__>(get_base1(B, i, "B", 1), get_base1(prior_beta, 1, "prior_beta", 1), get_base1(prior_beta, 2, "prior_beta", 1), get_base1(prior_beta, 3, "prior_beta", 1)));
                }
            }
            current_statement_begin__ = 158;
            if (as_bool(logical_eq(est_temporalRE, 1))) {
                current_statement_begin__ = 159;
                lp_accum__.add(student_t_log<propto__>(year_sigma, get_base1(prior_rw_sigma, 1, "prior_rw_sigma", 1), get_base1(prior_rw_sigma, 2, "prior_rw_sigma", 1), get_base1(prior_rw_sigma, 3, "prior_rw_sigma", 1)));
                current_statement_begin__ = 161;
                lp_accum__.add(student_t_log<propto__>(get_base1(yearEffects, 1, "yearEffects", 1), get_base1(prior_intercept, 1, "prior_intercept", 1), get_base1(prior_intercept, 2, "prior_intercept", 1), get_base1(prior_intercept, 3, "prior_intercept", 1)));
                current_statement_begin__ = 162;
                for (int t = 2; t <= nT; ++t) {
                    current_statement_begin__ = 163;
                    lp_accum__.add(normal_log<propto__>(get_base1(yearEffects, t, "yearEffects", 1), get_base1(yearEffects, (t - 1), "yearEffects", 1), year_sigma));
                }
            }
            current_statement_begin__ = 168;
            if (as_bool(logical_eq(est_df, 1))) {
                current_statement_begin__ = 169;
                lp_accum__.add(scaled_inv_chi_square_log<propto__>(W, get_base1(df, 1, "df", 1), 1));
                current_statement_begin__ = 170;
                lp_accum__.add(gamma_log<propto__>(df, 2, 0.1));
            } else {
                current_statement_begin__ = 172;
                if (as_bool(logical_gt(nW, 0))) {
                    current_statement_begin__ = 173;
                    lp_accum__.add(scaled_inv_chi_square_log<propto__>(W, fixed_df_value, 1));
                }
            }
            current_statement_begin__ = 177;
            if (as_bool(logical_gt(nW, 0))) {
                current_statement_begin__ = 179;
                lp_accum__.add(multi_normal_log<propto__>(get_base1(spatialEffectsKnots, 1, "spatialEffectsKnots", 1), muZeros, multiply(get_base1(W, 1, "W", 1), SigmaKnots)));
                current_statement_begin__ = 182;
                for (int t = 2; t <= nT; ++t) {
                    current_statement_begin__ = 183;
                    if (as_bool(logical_eq(est_phi, 1))) {
                        current_statement_begin__ = 184;
                        lp_accum__.add(multi_normal_log<propto__>(get_base1(spatialEffectsKnots, t, "spatialEffectsKnots", 1), multiply(get_base1(phi, 1, "phi", 1), get_base1(spatialEffectsKnots, (t - 1), "spatialEffectsKnots", 1)), multiply(get_base1(W, t, "W", 1), SigmaKnots)));
                    } else {
                        current_statement_begin__ = 187;
                        lp_accum__.add(multi_normal_log<propto__>(get_base1(spatialEffectsKnots, t, "spatialEffectsKnots", 1), multiply(fixed_phi_value, get_base1(spatialEffectsKnots, (t - 1), "spatialEffectsKnots", 1)), multiply(get_base1(W, t, "W", 1), SigmaKnots)));
                    }
                }
            } else {
                current_statement_begin__ = 192;
                lp_accum__.add(multi_normal_log<propto__>(get_base1(spatialEffectsKnots, 1, "spatialEffectsKnots", 1), muZeros, SigmaKnots));
                current_statement_begin__ = 193;
                for (int t = 2; t <= nT; ++t) {
                    current_statement_begin__ = 194;
                    if (as_bool(logical_eq(est_phi, 1))) {
                        current_statement_begin__ = 195;
                        lp_accum__.add(multi_normal_log<propto__>(get_base1(spatialEffectsKnots, t, "spatialEffectsKnots", 1), multiply(get_base1(phi, 1, "phi", 1), get_base1(spatialEffectsKnots, (t - 1), "spatialEffectsKnots", 1)), SigmaKnots));
                    } else {
                        current_statement_begin__ = 198;
                        lp_accum__.add(multi_normal_log<propto__>(get_base1(spatialEffectsKnots, t, "spatialEffectsKnots", 1), multiply(fixed_phi_value, get_base1(spatialEffectsKnots, (t - 1), "spatialEffectsKnots", 1)), SigmaKnots));
                    }
                }
            }
            current_statement_begin__ = 207;
            if (as_bool(logical_eq(obs_model, 0))) {
                current_statement_begin__ = 209;
                lp_accum__.add(student_t_log<propto__>(get_base1(CV, 1, "CV", 1), get_base1(prior_sigma, 1, "prior_sigma", 1), get_base1(prior_sigma, 2, "prior_sigma", 1), get_base1(prior_sigma, 3, "prior_sigma", 1)));
                current_statement_begin__ = 210;
                lp_accum__.add(gamma_log<propto__>(y, get_base1(gammaA, 1, "gammaA", 1), elt_divide(get_base1(gammaA, 1, "gammaA", 1), stan::math::exp(y_hat))));
            }
            current_statement_begin__ = 212;
            if (as_bool(logical_eq(obs_model, 1))) {
                current_statement_begin__ = 213;
                lp_accum__.add(student_t_log<propto__>(get_base1(sigma, 1, "sigma", 1), get_base1(prior_sigma, 1, "prior_sigma", 1), get_base1(prior_sigma, 2, "prior_sigma", 1), get_base1(prior_sigma, 3, "prior_sigma", 1)));
                current_statement_begin__ = 214;
                lp_accum__.add(normal_log<propto__>(y, y_hat, get_base1(sigma, 1, "sigma", 1)));
            }
            current_statement_begin__ = 216;
            if (as_bool(logical_eq(obs_model, 2))) {
                current_statement_begin__ = 217;
                lp_accum__.add(student_t_log<propto__>(get_base1(nb2_phi, 1, "nb2_phi", 1), get_base1(prior_sigma, 1, "prior_sigma", 1), get_base1(prior_sigma, 2, "prior_sigma", 1), get_base1(prior_sigma, 3, "prior_sigma", 1)));
                current_statement_begin__ = 218;
                if (as_bool(logical_eq(lower_truncation, 0))) {
                    current_statement_begin__ = 219;
                    lp_accum__.add(neg_binomial_2_log_log<propto__>(y_int, y_hat, get_base1(nb2_phi, 1, "nb2_phi", 1)));
                } else {
                    current_statement_begin__ = 221;
                    for (int i = 1; i <= N; ++i) {
                        current_statement_begin__ = 222;
                        lp_accum__.add(neg_binomial_2_log<propto__>(get_base1(y_int, i, "y_int", 1), stan::math::exp(get_base1(y_hat, i, "y_hat", 1)), get_base1(nb2_phi, 1, "nb2_phi", 1)));
                        if (get_base1(y_int, i, "y_int", 1) < lower_truncation) lp_accum__.add(-std::numeric_limits<double>::infinity());
                        else lp_accum__.add(-log_sum_exp(neg_binomial_2_ccdf_log(lower_truncation, stan::math::exp(get_base1(y_hat, i, "y_hat", 1)), get_base1(nb2_phi, 1, "nb2_phi", 1)), neg_binomial_2_log(lower_truncation, stan::math::exp(get_base1(y_hat, i, "y_hat", 1)), get_base1(nb2_phi, 1, "nb2_phi", 1))));
                    }
                }
            }
            current_statement_begin__ = 226;
            if (as_bool(logical_eq(obs_model, 4))) {
                current_statement_begin__ = 227;
                lp_accum__.add(binomial_logit_log<propto__>(y_int, binomialN, y_hat));
            }
            current_statement_begin__ = 229;
            if (as_bool(logical_eq(obs_model, 5))) {
                current_statement_begin__ = 230;
                lp_accum__.add(poisson_log_log<propto__>(y_int, y_hat));
            }
            current_statement_begin__ = 232;
            if (as_bool(logical_eq(obs_model, 6))) {
                current_statement_begin__ = 233;
                lp_accum__.add(student_t_log<propto__>(get_base1(sigma, 1, "sigma", 1), get_base1(prior_sigma, 1, "prior_sigma", 1), get_base1(prior_sigma, 2, "prior_sigma", 1), get_base1(prior_sigma, 3, "prior_sigma", 1)));
                current_statement_begin__ = 234;
                lp_accum__.add(lognormal_log<propto__>(y, y_hat, get_base1(sigma, 1, "sigma", 1)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("gp_theta");
        names__.push_back("gp_sigma");
        names__.push_back("df");
        names__.push_back("sigma");
        names__.push_back("CV");
        names__.push_back("nb2_phi");
        names__.push_back("yearEffects");
        names__.push_back("year_sigma");
        names__.push_back("spatialEffectsKnots");
        names__.push_back("B");
        names__.push_back("phi");
        names__.push_back("W");
        names__.push_back("muZeros");
        names__.push_back("spatialEffects");
        names__.push_back("SigmaKnots");
        names__.push_back("transformed_dist");
        names__.push_back("transformed_dist21");
        names__.push_back("SigmaOffDiag");
        names__.push_back("SigmaOffDiagTemp");
        names__.push_back("invSigmaKnots");
        names__.push_back("y_hat");
        names__.push_back("gammaA");
        names__.push_back("gp_sigma_sq");
        names__.push_back("log_lik");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(est_df);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(norm_params);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(gamma_params);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nb2_params);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_year_effects);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(est_temporalRE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nT);
        dims__.push_back(nKnots);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nCov);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(est_phi);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nW);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nKnots);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nT);
        dims__.push_back(nLocs);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nKnots);
        dims__.push_back(nKnots);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nKnots);
        dims__.push_back(nKnots);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nLocs);
        dims__.push_back(nKnots);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nLocs);
        dims__.push_back(nKnots);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nLocs);
        dims__.push_back(nKnots);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nLocs);
        dims__.push_back(nKnots);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(gamma_params);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_glmmfields_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double gp_theta = in__.scalar_lb_constrain(0);
        vars__.push_back(gp_theta);
        double gp_sigma = in__.scalar_lb_constrain(0);
        vars__.push_back(gp_sigma);
        std::vector<double> df;
        size_t df_d_0_max__ = est_df;
        df.reserve(df_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < df_d_0_max__; ++d_0__) {
            df.push_back(in__.scalar_lb_constrain(df_lower_bound));
        }
        size_t df_k_0_max__ = est_df;
        for (size_t k_0__ = 0; k_0__ < df_k_0_max__; ++k_0__) {
            vars__.push_back(df[k_0__]);
        }
        std::vector<double> sigma;
        size_t sigma_d_0_max__ = norm_params;
        sigma.reserve(sigma_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < sigma_d_0_max__; ++d_0__) {
            sigma.push_back(in__.scalar_lb_constrain(0));
        }
        size_t sigma_k_0_max__ = norm_params;
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
        }
        std::vector<double> CV;
        size_t CV_d_0_max__ = gamma_params;
        CV.reserve(CV_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < CV_d_0_max__; ++d_0__) {
            CV.push_back(in__.scalar_lb_constrain(0));
        }
        size_t CV_k_0_max__ = gamma_params;
        for (size_t k_0__ = 0; k_0__ < CV_k_0_max__; ++k_0__) {
            vars__.push_back(CV[k_0__]);
        }
        std::vector<double> nb2_phi;
        size_t nb2_phi_d_0_max__ = nb2_params;
        nb2_phi.reserve(nb2_phi_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < nb2_phi_d_0_max__; ++d_0__) {
            nb2_phi.push_back(in__.scalar_lb_constrain(0));
        }
        size_t nb2_phi_k_0_max__ = nb2_params;
        for (size_t k_0__ = 0; k_0__ < nb2_phi_k_0_max__; ++k_0__) {
            vars__.push_back(nb2_phi[k_0__]);
        }
        std::vector<double> yearEffects;
        size_t yearEffects_d_0_max__ = n_year_effects;
        yearEffects.reserve(yearEffects_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < yearEffects_d_0_max__; ++d_0__) {
            yearEffects.push_back(in__.scalar_constrain());
        }
        size_t yearEffects_k_0_max__ = n_year_effects;
        for (size_t k_0__ = 0; k_0__ < yearEffects_k_0_max__; ++k_0__) {
            vars__.push_back(yearEffects[k_0__]);
        }
        std::vector<double> year_sigma;
        size_t year_sigma_d_0_max__ = est_temporalRE;
        year_sigma.reserve(year_sigma_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < year_sigma_d_0_max__; ++d_0__) {
            year_sigma.push_back(in__.scalar_lb_constrain(0));
        }
        size_t year_sigma_k_0_max__ = est_temporalRE;
        for (size_t k_0__ = 0; k_0__ < year_sigma_k_0_max__; ++k_0__) {
            vars__.push_back(year_sigma[k_0__]);
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > spatialEffectsKnots;
        size_t spatialEffectsKnots_d_0_max__ = nT;
        spatialEffectsKnots.reserve(spatialEffectsKnots_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < spatialEffectsKnots_d_0_max__; ++d_0__) {
            spatialEffectsKnots.push_back(in__.vector_constrain(nKnots));
        }
        size_t spatialEffectsKnots_j_1_max__ = nKnots;
        size_t spatialEffectsKnots_k_0_max__ = nT;
        for (size_t j_1__ = 0; j_1__ < spatialEffectsKnots_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < spatialEffectsKnots_k_0_max__; ++k_0__) {
                vars__.push_back(spatialEffectsKnots[k_0__](j_1__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> B = in__.vector_constrain(nCov);
        size_t B_j_1_max__ = nCov;
        for (size_t j_1__ = 0; j_1__ < B_j_1_max__; ++j_1__) {
            vars__.push_back(B(j_1__));
        }
        std::vector<double> phi;
        size_t phi_d_0_max__ = est_phi;
        phi.reserve(phi_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < phi_d_0_max__; ++d_0__) {
            phi.push_back(in__.scalar_lub_constrain(-(1), 1));
        }
        size_t phi_k_0_max__ = est_phi;
        for (size_t k_0__ = 0; k_0__ < phi_k_0_max__; ++k_0__) {
            vars__.push_back(phi[k_0__]);
        }
        std::vector<double> W;
        size_t W_d_0_max__ = nW;
        W.reserve(W_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < W_d_0_max__; ++d_0__) {
            W.push_back(in__.scalar_lb_constrain(0));
        }
        size_t W_k_0_max__ = nW;
        for (size_t k_0__ = 0; k_0__ < W_k_0_max__; ++k_0__) {
            vars__.push_back(W[k_0__]);
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 56;
            validate_non_negative_index("muZeros", "nKnots", nKnots);
            Eigen::Matrix<double, Eigen::Dynamic, 1> muZeros(nKnots);
            stan::math::initialize(muZeros, DUMMY_VAR__);
            stan::math::fill(muZeros, DUMMY_VAR__);
            current_statement_begin__ = 57;
            validate_non_negative_index("spatialEffects", "nLocs", nLocs);
            validate_non_negative_index("spatialEffects", "nT", nT);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > spatialEffects(nT, Eigen::Matrix<double, Eigen::Dynamic, 1>(nLocs));
            stan::math::initialize(spatialEffects, DUMMY_VAR__);
            stan::math::fill(spatialEffects, DUMMY_VAR__);
            current_statement_begin__ = 58;
            validate_non_negative_index("SigmaKnots", "nKnots", nKnots);
            validate_non_negative_index("SigmaKnots", "nKnots", nKnots);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> SigmaKnots(nKnots, nKnots);
            stan::math::initialize(SigmaKnots, DUMMY_VAR__);
            stan::math::fill(SigmaKnots, DUMMY_VAR__);
            current_statement_begin__ = 59;
            validate_non_negative_index("transformed_dist", "nKnots", nKnots);
            validate_non_negative_index("transformed_dist", "nKnots", nKnots);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> transformed_dist(nKnots, nKnots);
            stan::math::initialize(transformed_dist, DUMMY_VAR__);
            stan::math::fill(transformed_dist, DUMMY_VAR__);
            current_statement_begin__ = 60;
            validate_non_negative_index("transformed_dist21", "nLocs", nLocs);
            validate_non_negative_index("transformed_dist21", "nKnots", nKnots);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> transformed_dist21(nLocs, nKnots);
            stan::math::initialize(transformed_dist21, DUMMY_VAR__);
            stan::math::fill(transformed_dist21, DUMMY_VAR__);
            current_statement_begin__ = 61;
            validate_non_negative_index("SigmaOffDiag", "nLocs", nLocs);
            validate_non_negative_index("SigmaOffDiag", "nKnots", nKnots);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> SigmaOffDiag(nLocs, nKnots);
            stan::math::initialize(SigmaOffDiag, DUMMY_VAR__);
            stan::math::fill(SigmaOffDiag, DUMMY_VAR__);
            current_statement_begin__ = 62;
            validate_non_negative_index("SigmaOffDiagTemp", "nLocs", nLocs);
            validate_non_negative_index("SigmaOffDiagTemp", "nKnots", nKnots);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> SigmaOffDiagTemp(nLocs, nKnots);
            stan::math::initialize(SigmaOffDiagTemp, DUMMY_VAR__);
            stan::math::fill(SigmaOffDiagTemp, DUMMY_VAR__);
            current_statement_begin__ = 63;
            validate_non_negative_index("invSigmaKnots", "nLocs", nLocs);
            validate_non_negative_index("invSigmaKnots", "nKnots", nKnots);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> invSigmaKnots(nLocs, nKnots);
            stan::math::initialize(invSigmaKnots, DUMMY_VAR__);
            stan::math::fill(invSigmaKnots, DUMMY_VAR__);
            current_statement_begin__ = 64;
            validate_non_negative_index("y_hat", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> y_hat(N);
            stan::math::initialize(y_hat, DUMMY_VAR__);
            stan::math::fill(y_hat, DUMMY_VAR__);
            current_statement_begin__ = 65;
            validate_non_negative_index("gammaA", "gamma_params", gamma_params);
            std::vector<double> gammaA(gamma_params, double(0));
            stan::math::initialize(gammaA, DUMMY_VAR__);
            stan::math::fill(gammaA, DUMMY_VAR__);
            current_statement_begin__ = 66;
            double gp_sigma_sq;
            (void) gp_sigma_sq;  // dummy to suppress unused var warning
            stan::math::initialize(gp_sigma_sq, DUMMY_VAR__);
            stan::math::fill(gp_sigma_sq, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 67;
            stan::math::assign(gp_sigma_sq, pow((gp_sigma * gp_sigma_scaling_factor), 2.0));
            current_statement_begin__ = 70;
            if (as_bool(logical_eq(cov_func, 0))) {
                current_statement_begin__ = 72;
                stan::math::assign(SigmaKnots, multiply(gp_sigma_sq, stan::math::exp(divide(minus(distKnots), gp_theta))));
                current_statement_begin__ = 74;
                stan::math::assign(SigmaOffDiagTemp, multiply(gp_sigma_sq, stan::math::exp(divide(minus(distKnots21), gp_theta))));
            }
            current_statement_begin__ = 76;
            if (as_bool(logical_eq(cov_func, 1))) {
                current_statement_begin__ = 78;
                stan::math::assign(SigmaKnots, multiply(gp_sigma_sq, stan::math::exp(multiply(-(inv((2.0 * pow(gp_theta, 2.0)))), distKnots))));
                current_statement_begin__ = 81;
                stan::math::assign(SigmaOffDiagTemp, multiply(gp_sigma_sq, stan::math::exp(multiply(-(inv((2.0 * pow(gp_theta, 2.0)))), distKnots21))));
            }
            current_statement_begin__ = 84;
            if (as_bool(logical_eq(cov_func, 2))) {
                current_statement_begin__ = 85;
                if (as_bool(logical_eq(matern_kappa, 1.5))) {
                    current_statement_begin__ = 87;
                    stan::math::assign(transformed_dist, divide(multiply(stan::math::sqrt(3.0), distKnots), gp_theta));
                    current_statement_begin__ = 88;
                    stan::math::assign(SigmaKnots, elt_multiply(multiply(gp_sigma_sq, add(1.0, transformed_dist)), stan::math::exp(minus(transformed_dist))));
                    current_statement_begin__ = 90;
                    stan::math::assign(transformed_dist21, divide(multiply(stan::math::sqrt(3.0), distKnots21), gp_theta));
                    current_statement_begin__ = 91;
                    stan::math::assign(SigmaOffDiagTemp, elt_multiply(multiply(gp_sigma_sq, add(1.0, transformed_dist21)), stan::math::exp(minus(transformed_dist21))));
                }
                current_statement_begin__ = 93;
                if (as_bool(logical_eq(matern_kappa, 2.5))) {
                    current_statement_begin__ = 95;
                    stan::math::assign(transformed_dist, divide(multiply(stan::math::sqrt(5.0), distKnots), gp_theta));
                    current_statement_begin__ = 96;
                    stan::math::assign(SigmaKnots, elt_multiply(multiply(gp_sigma_sq, add(add(1.0, transformed_dist), divide(elt_multiply(transformed_dist, transformed_dist), 3.0))), stan::math::exp(minus(transformed_dist))));
                    current_statement_begin__ = 99;
                    stan::math::assign(transformed_dist21, divide(multiply(stan::math::sqrt(5.0), distKnots21), gp_theta));
                    current_statement_begin__ = 100;
                    stan::math::assign(SigmaOffDiagTemp, elt_multiply(multiply(gp_sigma_sq, add(add(1.0, transformed_dist21), divide(elt_multiply(transformed_dist21, transformed_dist21), 3.0))), stan::math::exp(minus(transformed_dist21))));
                }
            }
            current_statement_begin__ = 105;
            for (int k = 1; k <= nKnots; ++k) {
                current_statement_begin__ = 106;
                stan::model::assign(muZeros, 
                            stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable muZeros");
            }
            current_statement_begin__ = 109;
            stan::math::assign(SigmaOffDiag, multiply(SigmaOffDiagTemp, inverse_spd(SigmaKnots)));
            current_statement_begin__ = 110;
            for (int t = 1; t <= nT; ++t) {
                current_statement_begin__ = 111;
                stan::model::assign(spatialEffects, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            multiply(SigmaOffDiag, get_base1(spatialEffectsKnots, t, "spatialEffectsKnots", 1)), 
                            "assigning variable spatialEffects");
            }
            current_statement_begin__ = 115;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 116;
                if (as_bool(logical_eq(est_temporalRE, 0))) {
                    current_statement_begin__ = 117;
                    if (as_bool(logical_eq(fixed_intercept, 0))) {
                        current_statement_begin__ = 118;
                        stan::model::assign(y_hat, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (multiply(get_base1(X, i, "X", 1), B) + get_base1(get_base1(spatialEffects, get_base1(yearID, i, "yearID", 1), "spatialEffects", 1), get_base1(stationID, i, "stationID", 1), "spatialEffects", 2)), 
                                    "assigning variable y_hat");
                    } else {
                        current_statement_begin__ = 120;
                        stan::model::assign(y_hat, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    get_base1(get_base1(spatialEffects, get_base1(yearID, i, "yearID", 1), "spatialEffects", 1), get_base1(stationID, i, "stationID", 1), "spatialEffects", 2), 
                                    "assigning variable y_hat");
                    }
                } else {
                    current_statement_begin__ = 123;
                    if (as_bool(logical_eq(nCov, 0))) {
                        current_statement_begin__ = 124;
                        stan::model::assign(y_hat, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (get_base1(get_base1(spatialEffects, get_base1(yearID, i, "yearID", 1), "spatialEffects", 1), get_base1(stationID, i, "stationID", 1), "spatialEffects", 2) + get_base1(yearEffects, get_base1(yearID, i, "yearID", 1), "yearEffects", 1)), 
                                    "assigning variable y_hat");
                    }
                    current_statement_begin__ = 126;
                    if (as_bool(logical_gt(nCov, 0))) {
                        current_statement_begin__ = 127;
                        stan::model::assign(y_hat, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    ((multiply(get_base1(X, i, "X", 1), B) + get_base1(get_base1(spatialEffects, get_base1(yearID, i, "yearID", 1), "spatialEffects", 1), get_base1(stationID, i, "stationID", 1), "spatialEffects", 2)) + get_base1(yearEffects, get_base1(yearID, i, "yearID", 1), "yearEffects", 1)), 
                                    "assigning variable y_hat");
                    }
                }
                current_statement_begin__ = 130;
                stan::model::assign(y_hat, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            (get_base1(y_hat, i, "y_hat", 1) + get_base1(offset, i, "offset", 1)), 
                            "assigning variable y_hat");
            }
            current_statement_begin__ = 133;
            if (as_bool(logical_eq(obs_model, 0))) {
                current_statement_begin__ = 134;
                stan::model::assign(gammaA, 
                            stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                            inv(pow(get_base1(CV, 1, "CV", 1), 2.0)), 
                            "assigning variable gammaA");
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 65;
            size_t gammaA_i_0_max__ = gamma_params;
            for (size_t i_0__ = 0; i_0__ < gammaA_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "gammaA[i_0__]", gammaA[i_0__], 0);
            }
            current_statement_begin__ = 66;
            check_greater_or_equal(function__, "gp_sigma_sq", gp_sigma_sq, 0);
            // write transformed parameters
            if (include_tparams__) {
                size_t muZeros_j_1_max__ = nKnots;
                for (size_t j_1__ = 0; j_1__ < muZeros_j_1_max__; ++j_1__) {
                    vars__.push_back(muZeros(j_1__));
                }
                size_t spatialEffects_j_1_max__ = nLocs;
                size_t spatialEffects_k_0_max__ = nT;
                for (size_t j_1__ = 0; j_1__ < spatialEffects_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < spatialEffects_k_0_max__; ++k_0__) {
                        vars__.push_back(spatialEffects[k_0__](j_1__));
                    }
                }
                size_t SigmaKnots_j_2_max__ = nKnots;
                size_t SigmaKnots_j_1_max__ = nKnots;
                for (size_t j_2__ = 0; j_2__ < SigmaKnots_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < SigmaKnots_j_1_max__; ++j_1__) {
                        vars__.push_back(SigmaKnots(j_1__, j_2__));
                    }
                }
                size_t transformed_dist_j_2_max__ = nKnots;
                size_t transformed_dist_j_1_max__ = nKnots;
                for (size_t j_2__ = 0; j_2__ < transformed_dist_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < transformed_dist_j_1_max__; ++j_1__) {
                        vars__.push_back(transformed_dist(j_1__, j_2__));
                    }
                }
                size_t transformed_dist21_j_2_max__ = nKnots;
                size_t transformed_dist21_j_1_max__ = nLocs;
                for (size_t j_2__ = 0; j_2__ < transformed_dist21_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < transformed_dist21_j_1_max__; ++j_1__) {
                        vars__.push_back(transformed_dist21(j_1__, j_2__));
                    }
                }
                size_t SigmaOffDiag_j_2_max__ = nKnots;
                size_t SigmaOffDiag_j_1_max__ = nLocs;
                for (size_t j_2__ = 0; j_2__ < SigmaOffDiag_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < SigmaOffDiag_j_1_max__; ++j_1__) {
                        vars__.push_back(SigmaOffDiag(j_1__, j_2__));
                    }
                }
                size_t SigmaOffDiagTemp_j_2_max__ = nKnots;
                size_t SigmaOffDiagTemp_j_1_max__ = nLocs;
                for (size_t j_2__ = 0; j_2__ < SigmaOffDiagTemp_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < SigmaOffDiagTemp_j_1_max__; ++j_1__) {
                        vars__.push_back(SigmaOffDiagTemp(j_1__, j_2__));
                    }
                }
                size_t invSigmaKnots_j_2_max__ = nKnots;
                size_t invSigmaKnots_j_1_max__ = nLocs;
                for (size_t j_2__ = 0; j_2__ < invSigmaKnots_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < invSigmaKnots_j_1_max__; ++j_1__) {
                        vars__.push_back(invSigmaKnots(j_1__, j_2__));
                    }
                }
                size_t y_hat_j_1_max__ = N;
                for (size_t j_1__ = 0; j_1__ < y_hat_j_1_max__; ++j_1__) {
                    vars__.push_back(y_hat(j_1__));
                }
                size_t gammaA_k_0_max__ = gamma_params;
                for (size_t k_0__ = 0; k_0__ < gammaA_k_0_max__; ++k_0__) {
                    vars__.push_back(gammaA[k_0__]);
                }
                vars__.push_back(gp_sigma_sq);
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 239;
            validate_non_negative_index("log_lik", "N", N);
            Eigen::Matrix<double, Eigen::Dynamic, 1> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 242;
            for (int i = 1; i <= N; ++i) {
                current_statement_begin__ = 243;
                if (as_bool(logical_eq(obs_model, 0))) {
                    current_statement_begin__ = 244;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                gamma_log(get_base1(y, i, "y", 1), get_base1(gammaA, 1, "gammaA", 1), (get_base1(gammaA, 1, "gammaA", 1) / stan::math::exp(get_base1(y_hat, i, "y_hat", 1)))), 
                                "assigning variable log_lik");
                }
                current_statement_begin__ = 246;
                if (as_bool(logical_eq(obs_model, 1))) {
                    current_statement_begin__ = 247;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                normal_log(get_base1(y, i, "y", 1), get_base1(y_hat, i, "y_hat", 1), get_base1(sigma, 1, "sigma", 1)), 
                                "assigning variable log_lik");
                }
                current_statement_begin__ = 249;
                if (as_bool(logical_eq(obs_model, 2))) {
                    current_statement_begin__ = 250;
                    if (as_bool(logical_eq(lower_truncation, 0))) {
                        current_statement_begin__ = 251;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    neg_binomial_2_log_log(get_base1(y_int, i, "y_int", 1), get_base1(y_hat, i, "y_hat", 1), get_base1(nb2_phi, 1, "nb2_phi", 1)), 
                                    "assigning variable log_lik");
                    } else {
                        current_statement_begin__ = 257;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    neg_binomial_2_log(get_base1(y_int, i, "y_int", 1), stan::math::exp(get_base1(y_hat, i, "y_hat", 1)), get_base1(nb2_phi, 1, "nb2_phi", 1)), 
                                    "assigning variable log_lik");
                    }
                }
                current_statement_begin__ = 260;
                if (as_bool(logical_eq(obs_model, 4))) {
                    current_statement_begin__ = 261;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                binomial_logit_log(get_base1(y_int, i, "y_int", 1), get_base1(binomialN, i, "binomialN", 1), get_base1(y_hat, i, "y_hat", 1)), 
                                "assigning variable log_lik");
                }
                current_statement_begin__ = 263;
                if (as_bool(logical_eq(obs_model, 5))) {
                    current_statement_begin__ = 264;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                poisson_log_log(get_base1(y_int, i, "y_int", 1), get_base1(y_hat, i, "y_hat", 1)), 
                                "assigning variable log_lik");
                }
                current_statement_begin__ = 267;
                if (as_bool(logical_eq(obs_model, 6))) {
                    current_statement_begin__ = 268;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                lognormal_log(get_base1(y, i, "y", 1), y_hat, get_base1(sigma, 1, "sigma", 1)), 
                                "assigning variable log_lik");
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 239;
            size_t log_lik_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                vars__.push_back(log_lik(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_glmmfields";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "gp_theta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "gp_sigma";
        param_names__.push_back(param_name_stream__.str());
        size_t df_k_0_max__ = est_df;
        for (size_t k_0__ = 0; k_0__ < df_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "df" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_k_0_max__ = norm_params;
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t CV_k_0_max__ = gamma_params;
        for (size_t k_0__ = 0; k_0__ < CV_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "CV" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t nb2_phi_k_0_max__ = nb2_params;
        for (size_t k_0__ = 0; k_0__ < nb2_phi_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nb2_phi" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t yearEffects_k_0_max__ = n_year_effects;
        for (size_t k_0__ = 0; k_0__ < yearEffects_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "yearEffects" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t year_sigma_k_0_max__ = est_temporalRE;
        for (size_t k_0__ = 0; k_0__ < year_sigma_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "year_sigma" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t spatialEffectsKnots_j_1_max__ = nKnots;
        size_t spatialEffectsKnots_k_0_max__ = nT;
        for (size_t j_1__ = 0; j_1__ < spatialEffectsKnots_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < spatialEffectsKnots_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "spatialEffectsKnots" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t B_j_1_max__ = nCov;
        for (size_t j_1__ = 0; j_1__ < B_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "B" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t phi_k_0_max__ = est_phi;
        for (size_t k_0__ = 0; k_0__ < phi_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t W_k_0_max__ = nW;
        for (size_t k_0__ = 0; k_0__ < W_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "W" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t muZeros_j_1_max__ = nKnots;
            for (size_t j_1__ = 0; j_1__ < muZeros_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "muZeros" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t spatialEffects_j_1_max__ = nLocs;
            size_t spatialEffects_k_0_max__ = nT;
            for (size_t j_1__ = 0; j_1__ < spatialEffects_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < spatialEffects_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "spatialEffects" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t SigmaKnots_j_2_max__ = nKnots;
            size_t SigmaKnots_j_1_max__ = nKnots;
            for (size_t j_2__ = 0; j_2__ < SigmaKnots_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < SigmaKnots_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "SigmaKnots" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t transformed_dist_j_2_max__ = nKnots;
            size_t transformed_dist_j_1_max__ = nKnots;
            for (size_t j_2__ = 0; j_2__ < transformed_dist_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < transformed_dist_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "transformed_dist" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t transformed_dist21_j_2_max__ = nKnots;
            size_t transformed_dist21_j_1_max__ = nLocs;
            for (size_t j_2__ = 0; j_2__ < transformed_dist21_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < transformed_dist21_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "transformed_dist21" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t SigmaOffDiag_j_2_max__ = nKnots;
            size_t SigmaOffDiag_j_1_max__ = nLocs;
            for (size_t j_2__ = 0; j_2__ < SigmaOffDiag_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < SigmaOffDiag_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "SigmaOffDiag" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t SigmaOffDiagTemp_j_2_max__ = nKnots;
            size_t SigmaOffDiagTemp_j_1_max__ = nLocs;
            for (size_t j_2__ = 0; j_2__ < SigmaOffDiagTemp_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < SigmaOffDiagTemp_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "SigmaOffDiagTemp" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t invSigmaKnots_j_2_max__ = nKnots;
            size_t invSigmaKnots_j_1_max__ = nLocs;
            for (size_t j_2__ = 0; j_2__ < invSigmaKnots_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < invSigmaKnots_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "invSigmaKnots" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t y_hat_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < y_hat_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_hat" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t gammaA_k_0_max__ = gamma_params;
            for (size_t k_0__ = 0; k_0__ < gammaA_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "gammaA" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "gp_sigma_sq";
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "gp_theta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "gp_sigma";
        param_names__.push_back(param_name_stream__.str());
        size_t df_k_0_max__ = est_df;
        for (size_t k_0__ = 0; k_0__ < df_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "df" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_k_0_max__ = norm_params;
        for (size_t k_0__ = 0; k_0__ < sigma_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t CV_k_0_max__ = gamma_params;
        for (size_t k_0__ = 0; k_0__ < CV_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "CV" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t nb2_phi_k_0_max__ = nb2_params;
        for (size_t k_0__ = 0; k_0__ < nb2_phi_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "nb2_phi" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t yearEffects_k_0_max__ = n_year_effects;
        for (size_t k_0__ = 0; k_0__ < yearEffects_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "yearEffects" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t year_sigma_k_0_max__ = est_temporalRE;
        for (size_t k_0__ = 0; k_0__ < year_sigma_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "year_sigma" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t spatialEffectsKnots_j_1_max__ = nKnots;
        size_t spatialEffectsKnots_k_0_max__ = nT;
        for (size_t j_1__ = 0; j_1__ < spatialEffectsKnots_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < spatialEffectsKnots_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "spatialEffectsKnots" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t B_j_1_max__ = nCov;
        for (size_t j_1__ = 0; j_1__ < B_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "B" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t phi_k_0_max__ = est_phi;
        for (size_t k_0__ = 0; k_0__ < phi_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t W_k_0_max__ = nW;
        for (size_t k_0__ = 0; k_0__ < W_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "W" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t muZeros_j_1_max__ = nKnots;
            for (size_t j_1__ = 0; j_1__ < muZeros_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "muZeros" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t spatialEffects_j_1_max__ = nLocs;
            size_t spatialEffects_k_0_max__ = nT;
            for (size_t j_1__ = 0; j_1__ < spatialEffects_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < spatialEffects_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "spatialEffects" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t SigmaKnots_j_2_max__ = nKnots;
            size_t SigmaKnots_j_1_max__ = nKnots;
            for (size_t j_2__ = 0; j_2__ < SigmaKnots_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < SigmaKnots_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "SigmaKnots" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t transformed_dist_j_2_max__ = nKnots;
            size_t transformed_dist_j_1_max__ = nKnots;
            for (size_t j_2__ = 0; j_2__ < transformed_dist_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < transformed_dist_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "transformed_dist" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t transformed_dist21_j_2_max__ = nKnots;
            size_t transformed_dist21_j_1_max__ = nLocs;
            for (size_t j_2__ = 0; j_2__ < transformed_dist21_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < transformed_dist21_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "transformed_dist21" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t SigmaOffDiag_j_2_max__ = nKnots;
            size_t SigmaOffDiag_j_1_max__ = nLocs;
            for (size_t j_2__ = 0; j_2__ < SigmaOffDiag_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < SigmaOffDiag_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "SigmaOffDiag" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t SigmaOffDiagTemp_j_2_max__ = nKnots;
            size_t SigmaOffDiagTemp_j_1_max__ = nLocs;
            for (size_t j_2__ = 0; j_2__ < SigmaOffDiagTemp_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < SigmaOffDiagTemp_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "SigmaOffDiagTemp" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t invSigmaKnots_j_2_max__ = nKnots;
            size_t invSigmaKnots_j_1_max__ = nLocs;
            for (size_t j_2__ = 0; j_2__ < invSigmaKnots_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < invSigmaKnots_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "invSigmaKnots" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t y_hat_j_1_max__ = N;
            for (size_t j_1__ = 0; j_1__ < y_hat_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_hat" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t gammaA_k_0_max__ = gamma_params;
            for (size_t k_0__ = 0; k_0__ < gammaA_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "gammaA" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "gp_sigma_sq";
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__) return;
        size_t log_lik_j_1_max__ = N;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_glmmfields_namespace::model_glmmfields stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
