#pragma once

#include "general.h"

// different instructions for the calculator
enum class Instruction{
  PushUserNumber0 = 0,
  PushUserNumber1 = 1,
  PushUserNumber2 = 2,
  PushUserNumber3 = 3,
  PushUserNumber4 = 4,
  PushUserNumber5 = 5,
  PushUserNumber6 = 6,
  PushUserNumber7 = 7,
  PushUserNumber8 = 8,
  PushUserNumber9 = 9,
  Add,
  Subtract,
  Multiply,
  Divide,
  PushData,
  PushCovData,
  PushParameter,
  PushY,
  Power,
  Exp,
  Sqrt,
  Square,
  Negate,
  Bessel,
  BesselK,
  Log,
  Gamma,
  Sin,
  Cos,
  PushExtraData,
  Int1,
  Int2,
  Int3,
  Int4,
  Int5,
  Int6,
  Int7,
  Int8,
  Int9,
  Int10,
  Pi,
  Constant1,
  Constant2,
  Constant3,
  Constant4,
  Constant5,
  Constant6,
  LogFactorialApprox,
  PushVariance
};

const static std::vector<Instruction> xvar_rpn = {Instruction::PushData,Instruction::PushCovData,Instruction::Subtract,Instruction::Square};

// for printing for debugging
const std::map<Instruction,std::string> instruction_str{{Instruction::Add, "Add"}, 
{Instruction::Subtract, "Subtract"}, 
{Instruction::Multiply, "Multiply"},
{Instruction::Divide, "Divide"},
{Instruction::PushData, "Push data"},
{Instruction::PushCovData, "Push cov data"},
{Instruction::PushParameter, "Push parameter"},
{Instruction::PushY, "Push y"},
{Instruction::Power, "Power"},
{Instruction::Exp, "Exp"},
{Instruction::Sqrt, "Sqrt"},
{Instruction::Square, "Square"},
{Instruction::Negate, "Negate"},
{Instruction::Bessel, "Bessel"},
{Instruction::BesselK, "BesselK"},
{Instruction::Log, "Log"},
{Instruction::Gamma, "Gamma"},
{Instruction::Sin, "Sin"},
{Instruction::Cos, "Cos"},
{Instruction::PushExtraData, "Push extra data"},
{Instruction::Int1, "Int 1"},
{Instruction::Int2, "Int 2"},
{Instruction::Int3, "Int 3"},
{Instruction::Int4, "Int 4"},
{Instruction::Int5, "Int 5"},
{Instruction::Int6, "Int 6"},
{Instruction::Int7, "Int 7"},
{Instruction::Int8, "Int 8"},
{Instruction::Int9, "Int 9"},
{Instruction::Int10, "Int 10"},
{Instruction::Pi, "Pi"},
{Instruction::Constant1, "Constant 1"},
{Instruction::Constant2, "Constant 2"},
{Instruction::Constant3, "Constant 3"},
{Instruction::Constant4, "Constant 4"},
{Instruction::Constant5, "Constant 5"},
{Instruction::Constant6, "Constant 6"},
{Instruction::LogFactorialApprox, "Log factorial approx"},
{Instruction::PushVariance, "Push variance"},
{Instruction::PushUserNumber0, "Push user number 0"},
{Instruction::PushUserNumber1, "Push user number 1"},
{Instruction::PushUserNumber2, "Push user number 2"},
{Instruction::PushUserNumber3, "Push user number 3"},
{Instruction::PushUserNumber4, "Push user number 4"},
{Instruction::PushUserNumber5, "Push user number 5"},
{Instruction::PushUserNumber6, "Push user number 6"},
{Instruction::PushUserNumber7, "Push user number 7"},
{Instruction::PushUserNumber8, "Push user number 8"},
{Instruction::PushUserNumber9, "Push user number 9"}
};
