% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aicreg_230218.R
\name{aicreg}
\alias{aicreg}
\title{Identify model based upon AIC criteria from a stepreg() putput}
\usage{
aicreg(
  xs,
  start,
  y_,
  event,
  steps_n = steps_n,
  family = family,
  object = NULL,
  track = 0
)
}
\arguments{
\item{xs}{predictor input - an n by p matrix, where n (rows) is sample size, and p (columns) 
the number of predictors.  Must be in matrix form for complete data, no NA's, no Inf's, etc.,
and not a data frame.}

\item{start}{start time, Cox model only - class numeric of length same as number of patients (n)}

\item{y_}{output vector: time, or stop time for Cox model, y_ 0 or 1 for binomial (logistic), numeric for gaussian. 
Must be a vector of length same as number of sample size.}

\item{event}{event indicator, 1 for event, 0 for census, Cox model only.
Must be a numeric vector of length same as sample size.}

\item{steps_n}{maximum number of steps done in stepwise regression fitting}

\item{family}{model family, "cox", "binomial" or "gaussian"}

\item{object}{A stepreg() output.  If NULL it will be derived.}

\item{track}{Indicate whether or not to update progress in the console.  Default of
0 suppresses these updates.  The option of 1 provides these updates.  In fitting 
clinical data with non full rank design matrix we have found some R-packages to
take a very long time or possibly get caught in infinite loops.  Therefore we allow
the user to track the package and judge whether things are moving forward or 
if the process should be stopped.}
}
\value{
The identified model in form of a glm() or coxph() output object, with an 
entry of the stepreg() output object.
}
\description{
Identify model based upon AIC criteria from a stepreg() putput
}
\examples{
set.seed(18306296)
sim.data=glmnetr.simdata(nrows=100, ncols=100, beta=c(0,1,1))
# this gives a more intersting case but takes longer to run
xs=sim.data$xs           
# this will work numerically
xs=sim.data$xs[,c(2,3,50:55)] 
y_=sim.data$yt  
event=sim.data$event
cox.aic.fit = aicreg(xs, NULL, y_, event, family="cox", steps_n=40) 
summary(cox.aic.fit)

y_=sim.data$yt  
norm.aic.fit = aicreg(xs, NULL, y_, NULL, family="gaussian", steps_n=40) 
summary(norm.aic.fit)

}
