% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geeglm.R
\name{stepCriterion.glmgee}
\alias{stepCriterion.glmgee}
\title{Variable selection in Generalized Estimating Equations}
\usage{
\method{stepCriterion}{glmgee}(
  model,
  criterion = c("p-value", "qic", "qicu", "adjr2"),
  direction = c("backward", "forward"),
  test = c("wald", "score"),
  level = 0.05,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{an object of the class glmgee which is obtained from the fit of a generalized estimating equation. The linear predictor of the model whose fit is stored in this glmgee object is the more complex candidate which should be considered by the variable selection procedure.}

\item{criterion}{an (optional) character string indicating the criterion which should be used to compare the candidate models. The available options are: QIC ("qic"), QICu ("qicu"), \emph{p}-value of a statistical test ("p-value") and adjusted deviance-based R-squared ("adjr2"). By default, \code{criterion} is set to be "p-value".}

\item{direction}{an (optional) character string indicating the mode of variable selection which should be used. The available options are: deleting variables ("backward")  and adding variables ("forward"). By default, \code{direction} is set to be "backward".}

\item{test}{an (optional) character string indicating the statistical test which should be used to compare nested models. The available options are: Wald ("wald") and generalized score ("score") tests. By default, \code{test} is set to be "wald".}

\item{level}{an (optional) numeric value in the interval (0,1) indicating the significance level chosen to perform the statistical tests. This is only appropiate if \code{criterion="p-value"}. By default, \code{level} is set to be 0.05.}

\item{verbose}{an (optional) logical switch indicating if should the report of results be printed. By default, \code{verbose} is set to be TRUE.}

\item{...}{further arguments passed to or from other methods. For example, \code{k}, that is, the magnitude of the penalty in the QIC (or the QICu), which by default is set to be 2.}
}
\value{
A list with the following objects:
\itemize{
\item{\code{initial}:}{ an expression describing the linear predictor of the "initial" model.}
\item{\code{final}:}{ an expression describing the linear predictor of the "final" model.}
\item{\code{criterion}:}{ a character string describing the criterion chosen to compare the candidate models.}
}
}
\description{
Performs variable selection in generalized estimating equations using a chosen model fit criterion.
}
\examples{
## Example 1
mod <- size ~ poly(days,4)*treat
fit1 <- glmgee(mod, id=tree, family=Gamma("log"), data=spruce, corstr="AR-1")
stepCriterion(fit1, criterion="p-value", direction="forward")
stepCriterion(fit1, criterion="p-value", direction="backward")

## Example 2
mod <- depressd ~ visit*group
fit2 <- glmgee(mod, id=subj, family=binomial("logit"), corstr="AR-1", data=depression)
stepCriterion(fit2, criterion="qic", direction="forward")
stepCriterion(fit2, criterion="qic", direction="backward")
}
\seealso{
\link{stepCriterion.lm}, \link{stepCriterion.glm}, \link{stepCriterion.overglm}
}
