% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Grass}
\alias{Grass}
\title{The effects of fertilizers on coastal Bermuda grass}
\format{
A data frame with 64 rows and 4 variables:
\describe{
  \item{Nitrogen}{a numeric vector indicating the Nitrogen level, in lb/acre.}
  \item{Phosphorus}{a numeric vector indicating the Phosphorus level, in lb/acre.}
  \item{Potassium}{a numeric vector indicating the Potassium level, in lb/acre.}
  \item{Yield}{a numeric vector indicating the yields, in tons/acre.}
}
}
\usage{
data(Grass)
}
\description{
These data arose from a \eqn{4^3} factorial experiment with the three major plant nutrients, nitrogen (N), phosphorus (P), and potassium (K), on the
yield of coastal Bermuda grass. The experiment was performed to produce a response surface for the effects of the three nutrients, so that an optimal
dressing could be predicted. The grass was cut about every five weeks and oven-dried.
}
\references{
Welch L.F., Adams W.E., Carmon J.L. (1963) Yield Response Surfaces, Isoquants, and Economic Fertilizer Optima for Coastal Bermuda grass.
            \emph{Agronomy Journal}, 55, 63-67.

McCullagh P., Nelder J.A. (1989). \emph{Generalized Linear Models. 2nd Edition}. Chapman and Hall, London.

Wei B.C. (1998). \emph{Exponential Family Nonlinear Models}. Springer, Singapore.
}
\keyword{datasets}
