% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glms.R
\name{BoxTidwell.glm}
\alias{BoxTidwell.glm}
\title{Box-Tidwell transformations in Generalized Linear Models}
\usage{
\method{BoxTidwell}{glm}(
  object,
  transf,
  epsilon = 1e-04,
  maxiter = 30,
  trace = FALSE,
  digits = max(3, getOption("digits") - 2),
  ...
)
}
\arguments{
\item{object}{an object of the class \emph{glm}.}

\item{transf}{an one-sided formula giving the quantitative predictors that are candidates for transformation.}

\item{epsilon}{an (optional) numerical value. If the maximum relative change in coefficients is less than
\emph{epsilon}, then convergence is declared. As default, \emph{epsilon} is set to 0.0001.}

\item{maxiter}{an (optional) positive integer value indicating the maximum number of iterations. By default,
\emph{maxiter} is set to 30.}

\item{trace}{an (optional) logical indicating if should the record of iterations be printed. By default,
\emph{trace} is set to FALSE.}

\item{digits}{an (optional) integer value indicating the number of decimal places to be used.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a list list with components including
\tabular{ll}{
\code{marginal} \tab a matrix with estimates, standard errors, and 95% confidence intervals for the powers, as well as the statistic
                      and the p-value of the Wald test to assess the hypothesis \eqn{H_0:\tau=1} versus \eqn{H_1:\tau\neq 1},\cr
\tab \cr
\code{omnibus} \tab a matrix with the statistic and the p-value of the Wald test for null hypothesis that all powers
                     are 1,\cr
}
}
\description{
Computes the Box-Tidwell power transformations of the predictors in a generalized linear model.
}
\examples{
###### Example 1: Skin cancer in women
data(skincancer)
fit1 <- glm(cases ~ age + city, offset=log(population), family=poisson(log), data=skincancer)
AIC(fit1)
BoxTidwell(fit1, transf= ~ age)
fit1 <- update(fit1,formula=. ~ I(age^(-1/2)) + city)
AIC(fit1)

###### Example 3: Gas mileage
data(Auto, package="ISLR")
fit3 <- glm(mpg ~ horsepower + weight, family=inverse.gaussian(log), data=Auto)
AIC(fit3)
BoxTidwell(fit3, transf= ~ horsepower + weight)
fit3 <- update(fit3,formula=. ~ I(horsepower^(-1/3)) + weight)
AIC(fit3)

###### Example 4: Advertising
data(advertising)
fit4 <- glm(sales ~ TV + radio, family=gaussian(log), data=advertising)
AIC(fit4)
BoxTidwell(fit4, transf= ~ TV)
fit4 <- update(fit4,formula=. ~ I(TV^(1/10)) + radio)
AIC(fit4)

###### Example 5: Leukaemia Patients
data(leuk, package="MASS")
fit5 <- glm(ifelse(time>=52,1,0) ~ ag + wbc, family=binomial, data=leuk)
AIC(fit5)
BoxTidwell(fit5, transf= ~ wbc)
fit5 <- update(fit5,formula=. ~ ag + I(wbc^(-0.18)))
AIC(fit5)

}
\references{
Box G.E.P., Tidwell P.W. (1962) Transformation of the independent variables. \emph{Technometrics} 4, 531-550.

Fox J. (2016) \emph{Applied Regression Analysis and Generalized Linear Models}, Third Edition. Sage.
}
\seealso{
\link{BoxTidwell.lm}
}
