% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micromass.R
\docType{data}
\name{micromass}
\alias{micromass}
\title{Micromass data set.}
\format{
A list with 10 groups of gram, each of which includes data from two species. There are 1300 variables in each group, characterizing the features of the gram. The pair of species contained in eac group:
\itemize{
  \item "QBG.CRP-JNH.ZIJ"
  \item "AUG.AEX-RTO.JFR"
  \item "QWP.LRO-RTO.TQH"
  \item "AUG.HSS-QWP.DRH"
  \item "QBG.KGI-JNH.FLH"
  \item "VVJ.KWJ-BUT.DNW"
  \item "VVJ.KSF-BUT.TRH"
  \item "NYV.VCE-EMD.FZO"
  \item "NYV.XSY-EMD.WXC"
  \item "BUT.BIK-BUT.YZE"
}
}
\source{
Original data link: \url{https://archive.ics.uci.edu/ml/datasets/MicroMass#}
}
\usage{
micromass
}
\description{
A data set about the identification of microorganisms (Mahe, P. et al., 2014). The original data set includes positive and negative gram from 9 genera, 20 species. There are 541 observations and 1300 variables in total. To verify the power of GLM transfer learning algorithms, Tian, Y. and Feng, Y., 2021 divides the whole data into 10 groups, each of which contains two specieisf gram data.
}
\references{
Mahe, P., Arsac, M., Chatellier, S., Monnin, V., Perrot, N., Mailler, S., Girard, V., Ramjeet, M., Surre, J., Lacroix, B. and van Belkum, A., 2014. \emph{Automatic identification of mixed bacterial species fingerprints in a MALDI-TOF mass-spectrum. Bioinformatics, 30(9), pp.1280-1286.}

Tian, Y. and Feng, Y., 2021. \emph{Transfer learning with high-dimensional generalized linear models. Submitted.}
}
\keyword{datasets}
