% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glottofilter.R
\name{glottofilter}
\alias{glottofilter}
\title{Filter glottodata by language, glottocode, etc.}
\usage{
glottofilter(
  glottodata = NULL,
  glottocode = NULL,
  location = NULL,
  name = NULL,
  family = NULL,
  family_id = NULL,
  continent = NULL,
  country = NULL,
  sovereignty = NULL,
  macroarea = NULL,
  expression = NULL,
  isocodes = NULL,
  colname = NULL,
  select = NULL,
  drop = NULL
)
}
\arguments{
\item{glottodata}{A glottodata table}

\item{glottocode}{A character vector of glottocodes}

\item{location}{A character vector with a location (either a continent, country, macroarea, or sovereignty)}

\item{name}{A character vector of language names}

\item{family}{A character vector of language families}

\item{family_id}{A character vector of language family IDs}

\item{continent}{A character vector of continents}

\item{country}{A character vector of countries}

\item{sovereignty}{Sovereignty}

\item{macroarea}{Glottolog macroarea}

\item{expression}{A regular expression}

\item{isocodes}{A character vector of iso639p3codes}

\item{colname}{A column name}

\item{select}{Character vector of things to select (only if colname is provided)}

\item{drop}{Character vector of things to drop (only if colname is provided)}
}
\value{
A subset of the original glottodata table (data.frame or sf) containing only filtered languages.
}
\description{
By default, the glottolog data will be used to filter from. But in case the user provides glottodata, this will be used.
}
\examples{
\donttest{
points <- glottofilter(location = "Australia")
points <- glottofilter(glottocode = "wari1268")
points <- glottofilter(family = "Indo-European")
points <- glottofilter(continent = "South America")
points <- glottofilter(family = "Indo-European", continent = "South America")
points <- glottofilter(country = c("Colombia", "Venezuela"))
points <- glottofilter(expression = family \%in\% c("Arawakan", "Tucanoan"))
points <- glottofilter(expression = family_size > 2)
points <- glottofilter(colname = "family", drop = "Indo-European")
}
}
\seealso{
glottofiltermap()
}
\concept{<glottofilter><glottosearch>}
