% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glottosave.R
\name{glottosave}
\alias{glottosave}
\title{Save glottodata, maps and plots}
\usage{
glottosave(glottodata, filename = NULL)
}
\arguments{
\item{glottodata}{User-provided glottodata}

\item{filename}{Filename either with or without file extension}
}
\value{
No object is returned, it will be save locally at the specified location
}
\description{
If no filename is provided, the name of the glottodata object will be used.
}
\details{
If no file extension is provided, a sensible default file extension is chosen. Dynamic maps
(tmap) are saved in .html format, static maps (tmap) are saved as .png.
Spatial data (sf) are saved as geopackage (.GPKG) by default, but .shp is
also possible.
}
\examples{
\donttest{
glottodata <- glottoget("demodata", meta = FALSE)
# Saves as .xlsx
glottosave(glottodata, filename = file.path(tempdir(), "glottodata") )

glottospacedata <- glottospace(glottodata)
# Saves as .GPKG
glottosave(glottodata, filename = file.path(tempdir(), "glottodata") )

glottomap <- glottomap(glottodata)
# Saves as .png
glottosave(glottomap, filename = file.path(tempdir(), "glottomap") )

# Saves as .html
glottomap <- glottomap(glottodata, type = "dynamic",
             filename = file.path(tempdir(), "glottomap") )
}
}
\seealso{
glottoget_glottodata

Other <glottodata>: 
\code{\link{glottoget}()}
}
\concept{<glottodata>}
