% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_help_files.R
\name{clifford_attractor}
\alias{clifford_attractor}
\title{clifford_attractor}
\usage{
clifford_attractor(n_iter, A=1.886, B=-2.357, C=-0.328, D=0.918, x0=0.1, y0=0)
}
\arguments{
\item{n_iter}{number of points to generate}

\item{A}{see details}

\item{B}{see details}

\item{C}{see details}

\item{D}{see details}

\item{x0}{The initial x-coordinate}

\item{y0}{The initial y-coordinate}
}
\value{
A dataframe containing X and Y coordinates of clifford attractor points, the angle and the distance between successive points.
}
\description{
A 2D chaotic attractor created by Clifford Pickover.
}
\details{
A clifford attractor is a 2D chaotic attractor given by the two equations:
X[i+1] = sin(a*Y[i]) - c*cos(a*X[i])
Y[i+1] = sin(b*X[i]) - d*cos(b*Y[i])
https://en.wikipedia.org/wiki/List_of_chaotic_maps
https://stackoverflow.com/q/51122970/2723734
}
\examples{
cliff_points <- clifford_attractor(1e4, 1.886,-2.357,-0.328, 0.918, 0.1, 0)
color_pal <- circular_palette(n=144, pal_function=rainbow)
cliff_points$color <- map_colors(color_pal, cliff_points$angle, min_limit=-pi, max_limit=pi)

gm <- GlowMapper4$new(xdim=240, ydim=240, blend_mode = "additive", nthreads=1)
gm$map(x=cliff_points$x, y=cliff_points$y, radius=0.1, color=cliff_points$color)
pd <- gm$output_dataframe(saturation = 1)

ggplot() +
  geom_raster(data = pd, aes(x = x, y = y, fill = rgb(r,g,b,a)), show.legend=FALSE) +
  coord_fixed(gm$aspect(), xlim = gm$xlim(), ylim = gm$ylim()) + 
  scale_fill_identity() + 
  theme_night()
}
