% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md-list.R
\name{md_list}
\alias{md_list}
\title{Markdown generic list}
\usage{
md_list(x, type = c("bullet", "ordered", "task"), ...)
}
\arguments{
\item{x}{A character vector of list items.}

\item{type}{The type of list to create; either bullet, ordered, or task.}

\item{...}{Arguments passed to the appropriate list type function.}
}
\value{
A \code{glue} vector with length equal to \code{x}.
}
\description{
Turn a character vector into a valid markdown list block. This is a generic
function that calls \code{\link[=md_bullet]{md_bullet()}}, \code{\link[=md_order]{md_order()}}, or \code{\link[=md_task]{md_task()}} depending on
what string is provided in the \code{type} argument.
}
\examples{
md_list(state.name[1:5], type = "bullet", marker = "+")
md_list(state.name[6:10], type = "ordered", marker = ")")
md_list(state.name[11:15], type = "task", check = 3:5)
}
\seealso{
Other container block functions: \code{\link{md_bullet}},
  \code{\link{md_define}}, \code{\link{md_order}},
  \code{\link{md_quote}}, \code{\link{md_task}}
}
\concept{container block functions}
