% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srmr.R
\name{srmr}
\alias{srmr}
\title{Standardized Root Mean Residual}
\usage{
srmr(
  S = NULL,
  Sigma = NULL,
  ybar = NULL,
  mu = NULL,
  lavaan_object = NULL,
  exo = TRUE
)
}
\arguments{
\item{S}{sample covariance matrix}

\item{Sigma}{model-implied covariance matrix}

\item{ybar}{sample mean vector}

\item{mu}{model-implied mean vector}

\item{lavaan_object}{is a fitted model of class \code{lavaan}}

\item{exo}{boolean argument indicating if model has exogenous covariates}
}
\value{
A list including the SRMR component names, sum of squared resdiauls
for each component, and the SRMR for each component.
}
\description{
Computes the square root of the discrepancy between the sample covariance and mean
and the model-implied covariance and mean.
}
\section{Details}{

\code{S}, \code{Sigma}, \code{ybar}, and \code{mu} must be of the same dimensions.

If the sum of the diagonal elements of \code{S} equal 1 such that \code{S} is a correlation matrix,
the variance component of SRMR is not included
}

\examples{
Sigma <- matrix(c(1.022, .550,  .622, .550, .928, .783, .622, .783, 1.150), 
                    nrow = 3)
S <- matrix(c(.770, .545, .515, .545, 1.003, .890, .515, .890, 1.211), 
            nrow = 3)
ybar <- c(2.516, 4.041, 5.021)
mu <- c(2.825, 3.877, 4.929)

srmr(S = S,  Sigma = Sigma, ybar = ybar, mu = mu)

}
