% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gstatCompatibility.R
\name{as.variogramModel}
\alias{as.variogramModel}
\alias{as.variogramModel.default}
\alias{as.variogramModel.gmCgram}
\alias{as.variogramModel.LMCAnisCompo}
\alias{as.variogramModel.CompLinModCoReg}
\title{Convert an LMC variogram model to gstat format}
\usage{
as.variogramModel(m, ...)

\method{as.variogramModel}{default}(m, ...)

\method{as.variogramModel}{gmCgram}(m, ...)

\method{as.variogramModel}{LMCAnisCompo}(m, V = NULL, prefix = NULL, ensurePSD = TRUE, ...)

\method{as.variogramModel}{CompLinModCoReg}(m, V = "alr", prefix = NULL, ensurePSD = TRUE, ...)
}
\arguments{
\item{m}{variogram model}

\item{...}{further arguments for generic functionality}

\item{V}{eventually, specification of the logratio representation to use
for compositional data (one of: a matrix of log-contrasts to use, or else one of
the strings "alr", "clr" or "ilr")}

\item{prefix}{optional, name prefix for the generated variables if a transformation is used}

\item{ensurePSD}{logical, should positive-definiteness be enforced? defaults to TRUE, which may
produce several scary looking but mostly danger-free warnings}
}
\value{
The LMC model specified in the format of package gstat, i.e. as the result
of using \code{\link[gstat:vgm]{gstat::vgm()}}
}
\description{
Convert a linear model of coregionalisation to the format of package gstat. See \code{\link[gstat:vgm]{gstat::vgm()}} for details.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Convert an LMC variogram model to gstat format

\item \code{gmCgram}: Convert an LMC variogram model to gstat format

\item \code{LMCAnisCompo}: Convert an LMC variogram model to gstat format

\item \code{CompLinModCoReg}: Convert an LMC variogram model to gstat format
}}

\examples{
data("jura", package = "gstat")
X = jura.pred[,1:2]
Zc = compositions::acomp(jura.pred[,7:13])
lrmd = compositions::CompLinModCoReg(formula=~nugget()+sph(1.5), comp=Zc)
as.variogramModel(lrmd, V="alr")
}
