% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/message.R
\name{insert_message}
\alias{insert_message}
\title{Insert a message into the gmail mailbox from a mime message}
\usage{
insert_message(mail, label_ids, type = c("multipart", "media", "resumable"),
  internal_date_source = c("dateHeader", "recievedTime"), user_id = "me")
}
\arguments{
\item{mail}{mime mail message created by mime}

\item{label_ids}{optional label ids to apply to the message}

\item{type}{the type of upload to perform}

\item{internal_date_source}{whether to date the object based on the date of
the message or when it was received by gmail.}

\item{user_id}{gmail user_id to access, special value of 'me' indicates the authenticated user.}
}
\description{
Insert a message into the gmail mailbox from a mime message
}
\examples{
\dontrun{
insert_message(mime(From="you@me.com", To="any@one.com",
                          Subject="hello", "how are you doing?"))
}
}
\references{
\url{https://developers.google.com/gmail/api/v1/reference/users/messages/insert}
}
\seealso{
Other message: \code{\link{attachment}},
  \code{\link{delete_message}},
  \code{\link{import_message}}, \code{\link{messages}},
  \code{\link{message}}, \code{\link{modify_message}},
  \code{\link{save_attachments}},
  \code{\link{save_attachment}},
  \code{\link{send_message}}, \code{\link{trash_message}},
  \code{\link{untrash_message}}
}

