% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_plabels.R
\name{delete_plabels}
\alias{delete_plabels}
\title{Delete participant labels in all apps}
\usage{
delete_plabels(oTree, del_plabel = TRUE, del_mturk = TRUE)
}
\arguments{
\item{oTree}{A list of data frames that were created by import_otree().}

\item{del_plabel}{Logical.
TRUE if all participant labels should be deleted.}

\item{del_mturk}{Logical.
TRUE if all MTurk variables should be deleted.}
}
\value{
This function returns a duplicate of the original oTree list of
data frames that do not include the participant labels and/or the MTurk
variables.
}
\description{
If you work with MTurk, the MTurk IDs will be stored in the
participant labels variable.
This function deletes this variable in all_apps_wide and every app data frame
in the list of data frames that was created by import_otree() and/or all
variables referring to MTurk, such as participant.mturk_worker_id.
}
\examples{
# Use package-internal list of oTree data frames
oTree <- gmoTree::oTree

# Show participant labels
oTree$all_apps_wide$participant.label
oTree$survey$participant.label

# Delete all participant labels
oTree2 <- delete_plabels(oTree)

# Show participant labels again
oTree2$all_apps_wide$participant.label
oTree2$survey$participant.label
}
