% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assignv.R
\name{assignv}
\alias{assignv}
\title{Assign a variable from all_apps_wide}
\usage{
assignv(oTree, variable, newvar)
}
\arguments{
\item{oTree}{A list of data frames that were
created by \code{\link{import_otree}}}

\item{variable}{Character. The variable in the \code{$all_apps_wide}
data frame that should be assigned to all other apps.}

\item{newvar}{Character. The name of the newly created variable.}
}
\value{
This function returns a duplicate of the
original oTree list of data frames
but with an additional column in all data frames. The additional column
contains data from the specified variable found in \code{$all_apps_wide}.
}
\description{
Assign a variable from \code{$all_apps_wide} to the other app data frames.
}
\examples{
# Use package-internal list of oTree data frames
oTree <- gmoTree::oTree

# Assign variable "survey.1.player.gender" and name it "gender"
oTree <- assignv(oTree = oTree,
                 variable = "survey.1.player.gender",
                 newvar = "gender")

# Show the new variable in some of the other app data frames
oTree$dictator$gender
oTree$chatapp$gender

# The variable is now duplicated in app "survey" because it is obtained from
# there (This can be avoided by naming the new variable the same as the old
# variable)
oTree$survey$gender
oTree$survey$player.gender

# In app "all_apps_wide," the variable is also there twice (This can be
# avoided by naming the new variable the same as the old variable)
oTree$all_apps_wide$gender
oTree$all_apps_wide$survey.1.player.gender
}
