% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_constant.R
\name{show_constant}
\alias{show_constant}
\title{Show constant columns}
\usage{
show_constant(oTree, value = "any")
}
\arguments{
\item{oTree}{A list of data frames created
with \code{\link[=import_otree]{import_otree()}}.}

\item{value}{The value that is controlled to be the same within a column.
If the value is set to \code{"any"}, the function checks for
columns where any possible values are identical.}
}
\value{
This function returns a list of vectors, one for each app,
\code{$all_apps_wide}, the \code{$Time} and/or the \code{$Chats} data frame.
Each vector contains the names of all variables with constant values.
If there are no variables with constant values, the vector is empty.
}
\description{
Show all variables with no variation in their values within each data frame
of the list of data frames (except the ones in the info list).
This function is useful for identifying unnecessary variables before
running an experiment.
It allows checking for columns with any unchanging value or only
a specific value.
}
\examples{
# Use package-internal list of oTree data frames
oTree <- gmoTree::oTree

# Show all columns that contain only NAs
show_constant(oTree = oTree)
show_constant(oTree = oTree, value = NA)

# Show all columns that contain only -99
show_constant(oTree = oTree, value = -99)
}
\keyword{oTree}
