% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argumentChecks.R
\name{in_paramspace_int}
\alias{in_paramspace_int}
\title{Determine whether the parameter vector lies in the parameter space or not}
\usage{
in_paramspace_int(p, M, d, all_boldA, alphas, all_Omega)
}
\arguments{
\item{p}{a positive integer specifying the autoregressive order of the model.}

\item{M}{a positive integer specifying the number of mixture components.}

\item{d}{number of time series in the system.}

\item{all_boldA}{3D array containing the \eqn{((dp)x(dp))} "bold A" matrices related to each mixture component VAR-process,
obtained from \code{form_boldA}. Will be computed if not given.}

\item{alphas}{(Mx1) vector containing all mixing weight parameters, obtained from \code{pick_alphas}.}

\item{all_Omega}{3D array containing all covariance matrices \eqn{\Omega_{m}}, obtained from \code{pick_Omegas}.}
}
\value{
Returns \code{TRUE} if the given parameter values are in the parameter space and \code{FALSE} otherwise.
  Does NOT consider the identifiability condition!
}
\description{
\code{in_paramspace_int} checks whether the parameter vector lies in the parameter
  space or not.
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
 }
}
