% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cfilter}
\alias{cfilter}
\title{Time Series Convolution Filters}
\usage{
cfilter(x, filter, sides, circular)
}
\arguments{
\item{x}{A \code{column vector} of length T}

\item{filter}{A \code{column vector} of length f}

\item{sides}{An \code{int} that takes either 1:for using past values only or 2: filter coefficients are centered around lag 0.}

\item{circular}{A \code{bool} that indicates if the filter should be wrapped around the ends of the time series.}
}
\value{
A \code{column vec} that contains the results of the filtering process.
}
\description{
Applies a convolution filter to a univariate time series.
}
\details{
This is a port of the cfilter function harnessed by the filter function in stats. 
It is about 5-7 times faster than R's base function. The benchmark was done on iMac Late 2013 using vecLib as the BLAS.
}
\examples{
x = 1:100
# 
cfilter(x, rep(1, 3), sides = 2, circular = FALSE)
# Using R's function
filter(x, rep(1, 3))
#
cfilter(x, rep(1, 3), sides = 1, circular = FALSE)
# Using R's function
filter(x, rep(1, 3), sides = 1)
#
cfilter(x, rep(1, 3), sides = 1, circular = TRUE)
# Using R's function
filter(x, rep(1, 3), sides = 1, circular = TRUE)
}
\author{
R Core Team and JJB
}
\keyword{internal}

