% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMWM.R
\name{compare.gmwm}
\alias{compare.gmwm}
\title{Graphically Compare GMWM Model Fit}
\usage{
compare.gmwm(..., background = "white", split = TRUE, CI = TRUE,
  auto.label.wvar = F, transparence = 0.1, line.color = NULL,
  CI.color = NULL, line.type = NULL, point.size = NULL,
  point.shape = NULL, title = "Comparison of Implied Wavelet Variance",
  title.size = 15, axis.label.size = 13, axis.tick.size = 11,
  axis.x.label = expression(paste("Scale ", tau)),
  axis.y.label = expression(paste("Wavelet Variance ", nu)),
  facet.label.size = 13, legend.label = NULL, legend.title = "",
  legend.key.size = 1.3, legend.title.size = 13, legend.text.size = 13,
  nrow = 1, plot.emp.wv = T)
}
\arguments{
\item{...}{Several \code{gmwm} objects}

\item{background}{A \code{string} that determines the graph background. It can be \code{'grey'} or \code{'white'}.}

\item{split}{A \code{boolean} that indicates whether the graphs should be separate (TRUE) or graphed ontop of each other (FALSE).}

\item{CI}{A \code{boolean} that indicates whether the confidence interval should be plotted.}

\item{auto.label.wvar}{A \code{boolean} that indicates whether legend label should indicate the gmwm objects are robust or classical}

\item{transparence}{A \code{double} that ranges from 0 to 1 that controls the transparency of the graph.}

\item{line.color}{A \code{vector} of \code{string} that indicates the color of lines.}

\item{CI.color}{A \code{vector} of \code{string} that indicates the color of the confidence interval (e.g. 'black', 'red', '#003C7D', etc.)}

\item{line.type}{A \code{vector} of \code{string} that indicates the type of lines.}

\item{point.size}{A \code{vector} of \code{integer} that indicates the size of points on lines.}

\item{point.shape}{A \code{vector} of \code{integer} that indicates the shape of points on lines.}

\item{title}{A \code{string} that indicates the title of the graph.}

\item{title.size}{An \code{integer} that indicates the size of title.}

\item{axis.label.size}{An \code{integer} that indicates the size of label.}

\item{axis.tick.size}{An \code{integer} that indicates the size of tick mark.}

\item{axis.x.label}{A \code{string} that indicates the label on x axis.}

\item{axis.y.label}{A \code{string} that indicates the label on y axis.}

\item{facet.label.size}{An \code{integer} that indicates the size of facet label.}

\item{legend.label}{A \code{vector} of \code{string} that indicates the labels on legend.}

\item{legend.title}{A \code{string} that indicates the title of legend.}

\item{legend.key.size}{A \code{double} that indicates the size of key (in centermeters) on legend.}

\item{legend.title.size}{An \code{integer} that indicates the size of title on legend.}

\item{legend.text.size}{An \code{integer} that indicates the size of key label on legend.}

\item{nrow}{An \code{integer} that indicates how many rows the graph should be arranged in.}

\item{plot.emp.wv}{A \code{boolean} that indicates whether Emp. WV should be plotted or not (Used in \code{compare.models}).}
}
\value{
A ggplot2 panel containing the graph of gmwm objects.
}
\description{
Creates GMWM model fits of different models within the same panel.
}
\details{
If only one object is supplied, this function is actually calling \code{plot.gmwm}. When the parameters \code{line.color}, 
\code{CI.color}, \code{line.type},  \code{point.size}, \code{point.shape} and \code{legend.label} are modified, please follow the rules of \code{\link{plot.gmwm}}.

When \code{CI = T}, for \code{CI.color}, specify the color for each object. 
For \code{line.color}, \code{line.type}, \code{point.size}, \code{point.shape},
specify the value of lower bound, upper bound, empirical wavelet variance (WV), implied WV respectively for each object.

When \code{CI = F}, you don't need \code{CI.color} this time. For \code{line.color}, \code{line.type}, \code{point.size}, \code{point.shape},
only specify the value of empirical WV and implied WV respectively.

Check the examples for help.
}
\examples{
\dontrun{# AR
set.seed(8836)
n = 200
x = gen.gts(AR1(phi = .1, sigma2 = 1) + AR1(phi = 0.95, sigma2 = .1), n)
GMWM1 = gmwm(AR1(), data = x)
GMWM2 = gmwm(2*AR1(), data = x)
compare.gmwm(GMWM1, GMWM2, split = FALSE)
compare.gmwm(GMWM1, GMWM2, point.size = rep(c(1,1,4,4),2), CI.color = c('black','grey'))
compare.gmwm(GMWM1, GMWM2, CI = F, point.size = rep(c(6,6),2))
}
}
\author{
JJB, Wenchao
}

