% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rw_to_wv}
\alias{rw_to_wv}
\title{Random Walk to WV}
\usage{
rw_to_wv(sig2, tau)
}
\arguments{
\item{sig2}{A \code{double} corresponding to variance of RW}

\item{tau}{A \code{vec} containing the scales e.g. 2^tau}
}
\value{
A \code{vec} containing the wavelet variance of the random walk.
}
\description{
This function compute the WV (haar) of a Random Walk process
}
\examples{
x.sim = cumsum(rnorm(100000))
ntau = floor(log(length(x.sim),2))
tau = 2^(1:ntau)
wv.theo = rw_to_wv(1,tau)
plot(tau, wv.theo, col = "red")
}

