% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_fit.R
\name{compare_fits}
\alias{compare_fits}
\title{Compare graphically two \code{gnsstsmodel} objects.}
\usage{
compare_fits(fit_1, fit_2, main = NULL, y_unit = "mm", x_unit = "days")
}
\arguments{
\item{fit_1}{A \code{gnsstsmodel} object.}

\item{fit_2}{A \code{gnsstsmodel} object.}

\item{main}{A \code{string} specifying the plot title.}

\item{y_unit}{A \code{string} specifying the y axis label.}

\item{x_unit}{A \code{string} specifying the x axis label.}
}
\value{
No return value. Produce a plot comparing two estimated models.
}
\description{
Compare graphically two \code{gnsstsmodel} objects.
}
\examples{
data(cola)
fit_gmwmx_1 = estimate_gmwmx(x = cola,
                             theta_0 = c(0.1,0.1,0.1,0.1), 
                             n_seasonal = 1, 
                             model_string = "wn+matern")
fit_gmwmx_2 = estimate_gmwmx(x = cola,
                             theta_0 = c(0.1,0.1,0.1), 
                             n_seasonal = 1, 
                             model_string = "wn+powerlaw")
compare_fits(fit_gmwmx_1, fit_gmwmx_2)
}
