% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PBO.R
\name{PBO_get_station}
\alias{PBO_get_station}
\title{Load station data from PBO}
\usage{
PBO_get_station(station_name, column, time_range = c(-Inf, Inf), scale = 1)
}
\arguments{
\item{station_name}{A \code{string} specifying the PBO station name.}

\item{column}{A \code{string} specifying the name of the column to extract.}

\item{time_range}{A \code{vector} of 2 specifying the time range of data to extract.}

\item{scale}{A \code{scalar} specifying an optional scaling parameter applied to the extracted data.}
}
\value{
A \code{gnssts} object that contains the data associated with the specified PBO station.
}
\description{
Load station data from PBO
}
\examples{
\dontrun{
pbo_cola_data = PBO_get_station("COLA", column="dE")
str(pbo_cola_data)
}
}
