% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_genesets_fisherexact.R
\name{test_genesets_fisherexact}
\alias{test_genesets_fisherexact}
\title{Geneset ORA using Fisher-exact test}
\usage{
test_genesets_fisherexact(
  genesets,
  genelist,
  require_nsignif = 1L,
  use_ease = FALSE
)
}
\arguments{
\item{genesets}{tibble with genesets, must contain columns 'id', 'ngenes' and 'ngenes_signif'}

\item{genelist}{tibble with genes, must contain column 'signif'. The number of rows in this table (where signif is not NA)
is assumed to be the total number of tested genes, the number of rows where signif==TRUE is assumed the total number of significant genes.}

\item{require_nsignif}{minimum number of 'signif genes' that overlap with a geneset; \code{NA} pvalues are returned for genesets with \code{ngenes_signif <= require_nsignif}.
This function 'prefilters' genesets, so beware that this will influence downstream multiple testing correction. Default is 1}

\item{use_ease}{use a more conservative score coined by DAVID online tools @ https://david.ncifcrf.gov/helps/functional_annotation.html#fisher}
}
\value{
input \code{genesets} table with results in the "pvalue" column
}
\description{
In most cases, it's more convenient to call the more generic \code{test_genesets} function which also deals with multiple-testing correction (per geneset source)

It is assumed that the \code{genesets} and \code{genelist} parameters are in sync, i.e. \code{genesets} provided
here is the result of the \code{filter_genesets()} function (using the same \code{genelist} table)

Same as hypergeometric for non-EASE, but slower because stats::fisher.test isn't vectorized

Only genesets with at least 1 significant gene are subjected to statistical testing (e.g. NA is returned for genesets without significant genes)
}
\examples{
\donttest{
# note; this example downloads data when first run, and typically takes ~60seconds

# store the downloaded files in the following directory. Here, the temporary file
# directory is used. Alternatively, consider storing this data in a more permanent location.
# e.g. output_dir="~/data/goat" on unix systems or output_dir="C:/data/goat" on Windows
output_dir = tempdir()

## first run the default example from test_genesets() to obtain input data
datasets = download_goat_manuscript_data(output_dir)
genelist = datasets$`Wingo 2020:mass-spec:PMID32424284`
genesets_asis = download_genesets_goatrepo(output_dir)
genesets_filtered = filter_genesets(genesets_asis, genelist)

## example: same results between Fisher-exact and hypergeometric tests
result_hg = test_genesets_hypergeometric(genesets_filtered, genelist, require_nsignif = 3L)
result_fe = test_genesets_fisherexact(genesets_filtered, genelist, require_nsignif = 3L)
all.equal(result_hg$pvalue, result_fe$pvalue)
}
}
\seealso{
\code{test_genesets}
}
