% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racurve.r
\name{racurve}
\alias{racurve}
\title{Rank-abundance curves}
\usage{
racurve(matrix, main = "Rank-abundance diagram", nlab = 0,
  ylog = FALSE, frequency = FALSE)
}
\arguments{
\item{matrix}{Community data, a matrix-like object with samples in rows.}

\item{main}{The main title (optional).}

\item{nlab}{Number of labeled species (default = 0). Species are labeled in decreasing order beginning from the highest relative abundance.}

\item{ylog}{If set on \code{TRUE} the y-axis is displayed on a log-scale.}

\item{frequency}{If set on \code{TRUE} frequencies of species are calculated instead of relative abundances.}
}
\value{
Returns an (invisible) list composed of:
  \item{\code{abund }}{abundance of each species (in decreasing order)}
  \item{\code{rel.abund }}{relative abundance of each species (in decreasing order)}
  \item{\code{freq }}{frequency of each species (in decreasing order)}
}
\description{
This function draws a rank-abundance curve for community data. You can optionally add labels for a selected number of species.
If you wish to draw multiple rank-abundance curves for selected samples use \code{\link{racurves}}.
}
\section{Details}{

Rank abundance curves or Whittaker plots (see \cite{Whittaker 1965}) are used to display relative species abundance as biodiversity component.
They are a means to visualize species richness and species evenness.
}

\examples{
## Draw rank-abundance curve
racurve(schedenveg)

## Draw rank-abundance curve and label first 5 species
racurve(schedenveg, nlab = 5)

## Draw rank-abundance curve with log-scaled axis
racurve(schedenveg, ylog = TRUE)

## Draw rank-abundance curve with frequencies and no main title
racurve(schedenveg, frequency = TRUE, nlab = 1, main = "")
}
\references{
Whittaker, R. H. (1965). Dominance and Diversity in Land Plant Communities: Numerical relations of species express the importance of competition in community function and evolution. \emph{Science} \strong{147 :} 250-260.
}
\seealso{
\code{\link{racurves}} for multiple curves and \code{\link[BiodiversityR]{rankabundance}} from package \code{BiodiversityR} for a more sophisticated function
}
\author{
Friedemann Goral (\email{fgoral@gwdg.de})
}
