% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_dockerfiles.R
\name{add_dockerfile}
\alias{add_dockerfile}
\alias{add_dockerfile_shinyproxy}
\alias{add_dockerfile_heroku}
\title{Create a Dockerfile for your App}
\usage{
add_dockerfile(
  path = "DESCRIPTION",
  output = "Dockerfile",
  pkg = get_golem_wd(),
  from = paste0("rocker/r-ver:", R.Version()$major, ".", R.Version()$minor),
  as = NULL,
  port = 80,
  host = "0.0.0.0",
  sysreqs = TRUE,
  repos = c(CRAN = "https://cran.rstudio.com/"),
  expand = FALSE,
  open = TRUE,
  update_tar_gz = TRUE,
  build_golem_from_source = TRUE,
  extra_sysreqs = NULL
)

add_dockerfile_shinyproxy(
  path = "DESCRIPTION",
  output = "Dockerfile",
  pkg = get_golem_wd(),
  from = paste0("rocker/r-ver:", R.Version()$major, ".", R.Version()$minor),
  as = NULL,
  sysreqs = TRUE,
  repos = c(CRAN = "https://cran.rstudio.com/"),
  expand = FALSE,
  open = TRUE,
  update_tar_gz = TRUE,
  build_golem_from_source = TRUE,
  extra_sysreqs = NULL
)

add_dockerfile_heroku(
  path = "DESCRIPTION",
  output = "Dockerfile",
  pkg = get_golem_wd(),
  from = paste0("rocker/r-ver:", R.Version()$major, ".", R.Version()$minor),
  as = NULL,
  sysreqs = TRUE,
  repos = c(CRAN = "https://cran.rstudio.com/"),
  expand = FALSE,
  open = TRUE,
  update_tar_gz = TRUE,
  build_golem_from_source = TRUE,
  extra_sysreqs = NULL
)
}
\arguments{
\item{path}{path to the DESCRIPTION file to use as an input.}

\item{output}{name of the Dockerfile output.}

\item{pkg}{Path to the root of the package. Default is \code{get_golem_wd()}.}

\item{from}{The FROM of the Dockerfile. Default is
FROM rocker/r-ver:\code{R.Version()$major}.\code{R.Version()$minor}.}

\item{as}{The AS of the Dockerfile. Default it NULL.}

\item{port}{The \code{options('shiny.port')} on which to run the App.
Default is 80.}

\item{host}{The \code{options('shiny.host')} on which to run the App.
Default is 0.0.0.0.}

\item{sysreqs}{boolean. If TRUE, the Dockerfile will contain sysreq installation.}

\item{repos}{character. The URL(s) of the repositories to use for \code{options("repos")}.}

\item{expand}{boolean. If \code{TRUE} each system requirement will have its own \code{RUN} line.}

\item{open}{boolean. Should the Dockerfile be open after creation? Default is \code{TRUE}.}

\item{update_tar_gz}{boolean. If \code{TRUE} and \code{build_golem_from_source} is also \code{TRUE},
an updated tar.gz is created.}

\item{build_golem_from_source}{boolean. If \code{TRUE} no tar.gz is created and
the Dockerfile directly mount the source folder.}

\item{extra_sysreqs}{character vector. Extra debian system requirements.
Will be installed with apt-get install.}
}
\value{
The \code{{dockerfiler}} object, invisibly.
}
\description{
Build a container containing your Shiny App. \code{add_dockerfile()} creates
a generic Dockerfile, while \code{add_dockerfile_shinyproxy()} and
\code{add_dockerfile_heroku()} creates platform specific Dockerfile.
}
\examples{
\donttest{
# Add a standard Dockerfile
if (interactive()){
   add_dockerfile()
}
# Add a Dockerfile for ShinyProxy
if (interactive()){
    add_dockerfile_shinyproxy()
}
# Add a Dockerfile for Heroku
if (interactive()){
    add_dockerfile_heroku()
}
}
}
