% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segments.R
\name{segment_ga4}
\alias{segment_ga4}
\title{Make a segment object for use}
\usage{
segment_ga4(name, segment_id = NULL, user_segment = NULL,
  session_segment = NULL)
}
\arguments{
\item{name}{The name of the segment for the reports.}

\item{segment_id}{The segment ID of a built in or custom segment e.g. gaid::-3}

\item{user_segment}{A list of \code{segment_define}'s that apply to users}

\item{session_segment}{A list of \code{segment_define}'s that apply to sessions}
}
\value{
a segmentFilter object. You can pass a list of these to the request.
}
\description{
A Segment is a subset of the Analytics data. 
For example, of the entire set of users, one Segment 
might be users from a particular country or city.
}
\details{
\code{segment_ga4} is the top heirarchy of segment creation, for which you will also need:
\itemize{
 \item \link{segment_define} : AND combination of segmentFilters
 \item \link{segment_vector_simple} or \link{segment_vector_sequence}
 \item \link{segment_element} that are combined in OR lists for \code{segment_vectors_*}
}
}

