% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client_id.R
\name{ga_clientid_deletion}
\alias{ga_clientid_deletion}
\title{Create or update a user deletion request}
\usage{
ga_clientid_deletion(userId, propertyId, idType = c("CLIENT_ID",
  "USER_ID", "APP_INSTANCE_ID"), propertyType = c("ga", "firebase"))
}
\arguments{
\item{userId}{A character vector of user ID's}

\item{propertyId}{The Google Analytics Web property or Firebase ProjectId you are deleting the user from.}

\item{idType}{Type of user. One of \code{APP_INSTANCE_ID, CLIENT_ID or USER_ID}.}

\item{propertyType}{Firebase or Google Analytics}
}
\value{
a data.frame with a row for each userID you sent in, plus a column with its \code{deletionRequestTime}
}
\description{
The Google Analytics User Deletion API allows customers to process deletions of data associated with a given user identifier.
}
\details{
The user explorer report in Google Analytics can give you the client.id you need to test. 

A data deletion request can be applied to either a Google Analytics web property (specified by \code{propertyType="ga"}) or Firebase application (\code{propertyType="firebase"}). A user whose data will be deleted can be specified by setting one of the identifiers the \code{userId} field. The type of the identifier must be specified inside \code{idType} field.

There is a quota of 500 queries per day per cloud project.

The API returns a User Deletion Request Resource with \code{deletionRequestTime} field set. This field is the point in time up to which all user data will be deleted. This means that all user data for the specified user identifier and Google Analytics property or Firebase project will be deleted up to this date and time - if the user with the same identifier returns after this date/time, they will reappear in reporting.
}
\examples{

\dontrun{

# make sure you are authenticated with user deletion scopes
options(googleAuthR.scopes.selected = "https://www.googleapis.com/auth/analytics.user.deletion")
ga_auth(new_user = TRUE)

# a vector of ids
ids <- c("1489547420.1526330722", "1138076389.1526568883")

# do the deletions
ga_clientid_deletion(ids, "UA-1234-2")
#                 userId   id_type  property      deletionRequestTime
#1 1489547420.1526330722 CLIENT_ID UA-1234-2 2018-05-20T19:43:33.540Z
#2 1138076389.1526568883 CLIENT_ID UA-1234-2 2018-05-20T19:43:36.218Z

}

}
\seealso{
\url{https://developers.google.com/analytics/devguides/config/userdeletion/v3/}

Other clientid functions: \code{\link{ga_clientid_activity_unnest}},
  \code{\link{ga_clientid_activity}},
  \code{\link{ga_clientid_hash}}
}
\concept{clientid functions}
