% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unsampled.R
\name{ga_unsampled_download}
\alias{ga_unsampled_download}
\title{Download Unsampled Report from Google Drive. You must be authenticated with the
same account that you setup the unsampled report. This means service account
authentication is not supported.}
\usage{
ga_unsampled_download(
  reportTitle,
  accountId,
  webPropertyId,
  profileId,
  downloadFile = TRUE
)
}
\arguments{
\item{reportTitle}{Title of Unsampled Report (case-sensitive)}

\item{accountId}{Account Id}

\item{webPropertyId}{Web Property Id}

\item{profileId}{Profile Id}

\item{downloadFile}{Default TRUE, whether to download, if FALSE returns a dataframe instead}
}
\value{
file location if \code{downloadFile} is TRUE, else a \code{data.frame} of download
}
\description{
Download Unsampled Report from Google Drive. You must be authenticated with the
same account that you setup the unsampled report. This means service account
authentication is not supported.
}
\examples{

\dontrun{

    # get data.frame of unsampled reports you have available
    unsample_list <- ga_unsampled_list(accountId = "12345", 
                                       webPropertyId = "UA-12345-4", 
                                       profileId = "129371234")
                                       
    # loop through unsampled reports and download as a list of data.frames
    dl <- lapply(unsample_list$title, ga_unsampled_download, 
                 accountId = "12345", 
                 webPropertyId = "UA-12345-4", 
                 profileId = "129371234", 
                 downloadFile = FALSE)
                 
    # inspect first data.frame
    dl[[1]]
    
    # download unsampled report to csv file
    ga_unsampled_download("my_report_title", 
                          accountId = "12345", 
                          webPropertyId = "UA-12345-4", 
                          profileId = "129371234")

}
}
\seealso{
Other unsampled download functions: 
\code{\link{ga_unsampled_list}()},
\code{\link{ga_unsampled}()}
}
\concept{unsampled download functions}
