% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth_gargle.R
\name{gar_token}
\alias{gar_token}
\title{Produce configured token}
\usage{
gar_token()
}
\value{
A `request` object (an S3 class provided by [httr][httr::httr]).
}
\description{
For internal use or for those programming around the Google API.
Returns a token pre-processed with [httr::config()]. Most users
do not need to handle tokens "by hand" or, even if they need some
control, [gar_auth()] is what they need. If there is no current
token, [gar_auth()] is called to either load from cache or
initiate OAuth2.0 flow.
If auth has been deactivated via [gar_deauth()], `gar_token()`
returns `NULL`.
}
\examples{
\dontrun{
req <- request_generate(
  "drive.files.get",
  list(fileId = "abc"),
  token = gar_token()
)
req
}
}
\seealso{
Other low-level API functions: \code{\link{gar_has_token}}
}
\concept{low-level API functions}
