% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy-buildtriggers.R
\name{cr_deploy_run_website}
\alias{cr_deploy_run_website}
\title{Deploy HTML built from a repo each commit}
\usage{
cr_deploy_run_website(
  repo,
  image = paste0("website-", format(Sys.Date(), "\%Y\%m\%d")),
  rmd_folder = NULL,
  html_folder = NULL,
  image_tag = "$SHORT_SHA",
  timeout = 600L,
  edit_r = NULL,
  r_image = "gcr.io/gcer-public/packagetools:latest",
  allowUnauthenticated = TRUE,
  region = cr_region_get(),
  projectId = cr_project_get()
)
}
\arguments{
\item{repo}{A git repository defined in \link{cr_buildtrigger_repo}}

\item{image}{The name of the image you want to build}

\item{rmd_folder}{A folder of Rmd files within GitHub source that will be built into HTML for serving via \link[rmarkdown]{render}}

\item{html_folder}{A folder of html to deploy within GitHub source.  Will be ignored if rmd_folder is not NULL}

\item{image_tag}{What to tag the build docker image}

\item{timeout}{Timeout for the build}

\item{edit_r}{If you want to change the R code to render the HTML, supply R code via a file or string of R as per \link{cr_buildstep_r}}

\item{r_image}{The image that will run the R code from \code{edit_r}}

\item{allowUnauthenticated}{TRUE if can be reached from public HTTP address.}

\item{region}{The region for cloud run}

\item{projectId}{The project to build under}
}
\description{
This lets you set up triggers that will update an R generated website each commit.
}
\details{
This lets you render the Rmd (or other R functions that produce HTML) in a folder for your repo, which will then be hosted on a Cloud Run enabled with nginx.  Each time you push to git with modified Rmd code, it will build the new HTML and push an update to the website.

This default R code is rendered in the rmd_folder:

\code{lapply(list.files('.', pattern = '.Rmd', full.names = TRUE),
      rmarkdown::render, output_format = 'html_document')}
}
\examples{

\dontrun{
cr_project_set("my-project")
cr_region_set("europe-west1")
your_repo <- cr_buildtrigger_repo("MarkEdmondson1234/googleCloudRunner")
cr_deploy_run_website(your_repo, rmd_folder = "vignettes")

# change the Rmd rendering to pkgdown
r <- "devtools::install();pkgdown::build_site()"

cr_deploy_run_website(your_repo,
                   image = paste0(your_repo, "-pkgdown"),
                   rmd_folder = ".",
                   edit_r = r)

}
}
\seealso{
\link{cr_deploy_html} that lets you deploy just HTML files and \link{cr_deploy_pkgdown} for running pkgdown websites.

Other Deployment functions: 
\code{\link{cr_deploy_docker_trigger}()},
\code{\link{cr_deploy_docker}()},
\code{\link{cr_deploy_packagetests}()},
\code{\link{cr_deploy_pkgdown}()},
\code{\link{cr_deploy_run}()},
\code{\link{cr_deploy_r}()}
}
\concept{Deployment functions}
