% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildtrigger_objects.R
\name{BuildTrigger}
\alias{BuildTrigger}
\title{BuildTrigger Object}
\usage{
BuildTrigger(
  filename = NULL,
  name = NULL,
  tags = NULL,
  build = NULL,
  ignoredFiles = NULL,
  github = NULL,
  substitutions = NULL,
  includedFiles = NULL,
  disabled = NULL,
  sourceToBuild = NULL,
  triggerTemplate = NULL,
  webhookConfig = NULL,
  description = NULL,
  pubsubConfig = NULL
)
}
\arguments{
\item{filename}{Path, from the source root, to a file whose contents is used for the build}

\item{name}{User assigned name of the trigger}

\item{tags}{Tags for annotation of a `BuildTrigger`}

\item{build}{Contents of the build template}

\item{ignoredFiles}{ignored_files and included_files are file glob matches extended with support for "**".}

\item{github}{a \link{GitHubEventsConfig} object - mutually exclusive with \code{triggerTemplate}}

\item{substitutions}{A named list of Build macro variables}

\item{includedFiles}{If any of the files altered in the commit pass the ignored_files}

\item{disabled}{If true, the trigger will never result in a build}

\item{sourceToBuild}{A \link{cr_buildtrigger_repo} object (but no regex allowed for branch or tag)  This field is currently only used by Webhook, Pub/Sub, Manual, and Cron triggers and is the source of the build will execute upon.}

\item{triggerTemplate}{a \link{RepoSource} object - mutually exclusive with \code{github}}

\item{webhookConfig}{WebhookConfig describes the configuration of a trigger that creates a build whenever a webhook is sent to a trigger's webhook URL.}

\item{description}{Human-readable description of this trigger}

\item{pubsubConfig}{PubsubConfig describes the configuration of a trigger that creates a build whenever a Pub/Sub message is published.}
}
\value{
BuildTrigger object
}
\description{
Configuration for an automated build in response to source repositorychanges.
}
\seealso{
\url{https://cloud.google.com/build/docs/api/reference/rest/v1/projects.triggers}

Other BuildTrigger functions: 
\code{\link{GitHubEventsConfig}()},
\code{\link{cr_buildtrigger_copy}()},
\code{\link{cr_buildtrigger_delete}()},
\code{\link{cr_buildtrigger_edit}()},
\code{\link{cr_buildtrigger_get}()},
\code{\link{cr_buildtrigger_list}()},
\code{\link{cr_buildtrigger_pubsub}()},
\code{\link{cr_buildtrigger_repo}()},
\code{\link{cr_buildtrigger_run}()},
\code{\link{cr_buildtrigger_webhook}()},
\code{\link{cr_buildtrigger}()}
}
\concept{BuildTrigger functions}
