% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_targets.R, R/buildstep_targets.R
\name{cr_build_targets}
\alias{cr_build_targets}
\alias{cr_build_targets_artifacts}
\alias{cr_buildstep_targets_single}
\alias{cr_buildstep_targets_multi}
\title{Set up Google Cloud Build to run a targets pipeline}
\usage{
cr_build_targets(
  buildsteps = cr_buildstep_targets_multi(),
  execute = c("trigger", "now"),
  path = "cloudbuild_targets.yaml",
  local = ".",
  predefinedAcl = "bucketLevel",
  bucket = cr_bucket_get(),
  download_folder = getwd(),
  ...
)

cr_build_targets_artifacts(
  build,
  bucket = cr_bucket_get(),
  target_folder = NULL,
  download_folder = NULL,
  target_subfolder = c("all", "meta", "objects", "user"),
  overwrite = TRUE
)

cr_buildstep_targets_single(
  target_folder = NULL,
  bucket = cr_bucket_get(),
  tar_config = NULL,
  task_image = "gcr.io/gcer-public/targets",
  task_args = NULL,
  tar_make = "targets::tar_make()"
)

cr_buildstep_targets_multi(
  target_folder = NULL,
  bucket = cr_bucket_get(),
  tar_config = NULL,
  task_image = "gcr.io/gcer-public/targets",
  task_args = NULL,
  last_id = NULL
)
}
\arguments{
\item{buildsteps}{Generated buildsteps that create the targets build}

\item{execute}{Whether to run the Cloud Build now or to write to a file for use within triggers or otherwise}

\item{path}{File path to write the Google Cloud Build yaml workflow file. Set to NULL to write no file and just return the \code{Yaml} object.}

\item{local}{If executing now, the local folder that will be uploaded as the context for the target build}

\item{predefinedAcl}{The ACL rules for the object uploaded. Set to "bucketLevel" for buckets with bucket level access enabled}

\item{bucket}{The Google Cloud Storage bucket the target metadata will be saved to in folder `target_folder`}

\item{download_folder}{Set to NULL to overwrite local _target folder: \code{_targets/*} otherwise will write to \code{download_folder/_targets/*}}

\item{...}{
  Arguments passed on to \code{\link[=cr_build_yaml]{cr_build_yaml}}, \code{\link[=cr_build_yaml]{cr_build_yaml}}
  \describe{
    \item{\code{steps}}{A vector of \link{cr_buildstep}}
    \item{\code{timeout}}{How long the entire build will run. If not set will be 10mins}
    \item{\code{logsBucket}}{Where logs are written.  If you don't set this field, Cloud Build will use a default bucket to store your build logs.}
    \item{\code{options}}{A named list of options}
    \item{\code{substitutions}}{Build macros that will replace entries in other elements}
    \item{\code{tags}}{Tags for the build}
    \item{\code{secrets}}{A secrets object}
    \item{\code{images}}{What images will be build from this cloudbuild}
    \item{\code{artifacts}}{What artifacts may be built from this cloudbuild - create via \link{cr_build_yaml_artifact}}
    \item{\code{availableSecrets}}{What environment arguments from Secret Manager are available to the build - create via \link{cr_build_yaml_secrets}}
    \item{\code{serviceAccount}}{What service account should the build be run under?}
  }}

\item{build}{A \link{Build} object that includes the artifact location}

\item{target_folder}{Where target metadata will sit within the Google Cloud Storage bucket as a folder.  If NULL defaults to RStudio project name or "targets_cloudbuild" if no RStudio project found.}

\item{target_subfolder}{If you only want to download a specific folder from the _targets/ folder on Cloud Build then specify it here.}

\item{overwrite}{Whether to overwrite existing local data}

\item{tar_config}{An R script that will run before \code{targets::tar_make()} in the build e.g. \code{"targets::tar_config_set(script = 'targets/_targets.R')"}}

\item{task_image}{An existing Docker image that will be used to run your targets workflow after the targets meta has been downloaded from Google Cloud Storage}

\item{task_args}{A named list of additional arguments to send to \link{cr_buildstep_r} when its executing the \link[targets]{tar_make} command (such as environment arguments)}

\item{tar_make}{The R script that will run in the tar_make() step. Modify to include custom settings such as "script"}

\item{last_id}{The final buildstep that needs to complete before the upload.  If left NULL then will default to the last tar_target step.}
}
\value{
A Yaml object as generated by \link{cr_build_yaml} if \code{execute="trigger"} or the built object if \code{execute="now"}

\code{cr_build_targets_artifacts} returns the file path to where the download occurred.
}
\description{
Creates a Google Cloud Build yaml file so as to execute \link[targets]{tar_make} pipelines

Historical runs accumulate in the
  configured Google Cloud Storage bucket, and the latest output is downloaded before
  \link[targets]{tar_make} executes so up-to-date steps do not rerun.
}
\details{
Steps to set up your target task in Cloud Build:

\itemize{
  \item Create your `targets` workflow.
  \item Create a Dockerfile that holds the R and system dependencies for your workflow.  You can test the image using \link{cr_deploy_docker}.  Include \code{library(targets)} dependencies - a Docker image with \code{targets} installed is available at \code{gcr.io/gcer-public/targets}.
  \item Run \code{cr_build_targets} to create the cloudbuild yaml file.
  \item Run the build via \link{cr_build} or similar.  Each build should only recompute outdated targets.
  \item Optionally create a build trigger via \link{cr_buildtrigger}.
  \item Trigger a build. The first trigger will run the targets pipeline, subsequent runs will only recompute the outdated targets.
 }

Use \code{cr_build_targets_artifacts} to download the return values of a
  target Cloud Build, then \link[targets]{tar_read} to read the results.  You can set the downloaded files as the target store via \code{targets::tar_config_set(store="_targets_cloudbuild")}.  Set \code{download_folder = "_targets"} to overwrite your local targets store.
}
\section{DAGs}{


If your target workflow has parallel processing steps then leaving this as default \code{cr_buildstep_targets_multi()} will create a build that uses waitFor and build ids to create a DAG.  Setting this to \code{cr_buildstep_targets_single()} will be single thread but you can then customise the \code{targets::tar_make} script.  Or add your own custom target buildsteps here using \link{cr_buildstep_targets} - for example you could create the docker environment targets runs within before the main pipeline.
}

\examples{

write.csv(mtcars, file = "mtcars.csv", row.names = FALSE)

targets::tar_script(
  list(
    targets::tar_target(file1,
      "mtcars.csv", format = "file"),
    targets::tar_target(input1,
      read.csv(file1)),
    targets::tar_target(result1,
      sum(input1$mpg)),
    targets::tar_target(result2,
      mean(input1$mpg)),
    targets::tar_target(result3,
      max(input1$mpg)),
    targets::tar_target(result4,
      min(input1$mpg)),
    targets::tar_target(merge1,
      paste(result1, result2, result3, result4))
    ),
 ask = FALSE)

bs <- cr_buildstep_targets_multi()

# only create the yaml
par_build <- cr_build_targets(bs, path = NULL)
par_build

# clean up example
unlink("mtcars.csv")
unlink("_targets.R")

\dontrun{
# run it immediately in cloud
cr_build_targets(bs, execute="now")

# create a yaml file for use in build triggers
cr_build_targets(bs)
}

}
\seealso{
\link{cr_buildstep_targets} if you want to customise the build

Other Cloud Build functions: 
\code{\link{Build}()},
\code{\link{RepoSource}()},
\code{\link{Source}()},
\code{\link{StorageSource}()},
\code{\link{cr_build_artifacts}()},
\code{\link{cr_build_list}()},
\code{\link{cr_build_logs}()},
\code{\link{cr_build_make}()},
\code{\link{cr_build_status}()},
\code{\link{cr_build_upload_gcs}()},
\code{\link{cr_build_wait}()},
\code{\link{cr_build_write}()},
\code{\link{cr_build_yaml_artifact}()},
\code{\link{cr_build_yaml_secrets}()},
\code{\link{cr_build_yaml}()},
\code{\link{cr_build}()}
}
\concept{Cloud Build functions}
