% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disks.R
\name{gce_attach_disk}
\alias{gce_attach_disk}
\title{Attaches a Disk resource to an instance.}
\usage{
gce_attach_disk(instance, source = NULL, autoDelete = NULL, boot = NULL,
  deviceName = NULL, diskEncryptionKey = NULL, index = NULL,
  initializeParams = NULL, interface = NULL, licenses = NULL,
  mode = NULL, type = NULL, project = gce_get_global_project(),
  zone = gce_get_global_zone())
}
\arguments{
\item{instance}{The instance name for this request}

\item{source}{Specifies a valid partial or full URL to an existing Persistent Disk resource}

\item{autoDelete}{Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance)}

\item{boot}{Indicates that this is a boot disk}

\item{deviceName}{Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance}

\item{diskEncryptionKey}{Encrypts or decrypts a disk using a customer-supplied encryption key}

\item{index}{Assigns a zero-based index to this disk, where 0 is reserved for the boot disk}

\item{initializeParams}{A \link{gce_make_boot_disk} object for creating boot disks. Cannot be used with \code{source} also defined.}

\item{interface}{Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME}

\item{licenses}{[Output Only] Any valid publicly visible licenses}

\item{mode}{The mode in which to attach this disk, either READ_WRITE or READ_ONLY}

\item{type}{Specifies the type of the disk, either SCRATCH or PERSISTENT}

\item{project}{Project ID for this request}

\item{zone}{The name of the zone for this request}
}
\description{
Attaches a Disk resource to an instance.
}
\details{
Authentication scopes used by this function are:
\itemize{
  \item https://www.googleapis.com/auth/cloud-platform
\item https://www.googleapis.com/auth/compute
}
}
\seealso{
\href{https://cloud.google.com/compute/docs/reference/latest/disks}{Google Documentation}

Other AttachedDisk functions: \code{\link{AttachedDisk}}
}
