% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Encode.R
\name{encode}
\alias{encode}
\alias{encode.sf}
\alias{encode.data.frame}
\title{Encode}
\usage{
encode(obj, ...)

\method{encode}{sf}(obj, strip = FALSE, ...)

\method{encode}{data.frame}(obj, lon = NULL, lat = NULL, ...)
}
\arguments{
\item{obj}{either an \code{sf} object or \code{data.frame}}

\item{...}{other parameters passed to methods}

\item{strip}{logical indicating if \code{sf} attributes should be stripped. 
Useful if you want to reduce the size even further, but you will lose the 
spatial attributes associated with the \code{sf} object}

\item{lon}{vector of longitudes}

\item{lat}{vector of latitudes}
}
\value{
encoded object
}
\description{
Encodes coordinates into an encoded polyline.
}
\details{
The function assumes Google Web Mercator projection (WSG 84 / EPSG:3857 / EPSG:900913)
for inputs and outputs.

Will work with
\itemize{
  \item{\code{sf} and \code{sfc} objects} directly
  \item{\code{data.frames}} - It will attempt to find lat & lon coordinates, 
  or you can explicitely define them using the \code{lat} and \code{lon} arguments
}
}
\note{
When encoding an \code{sf} object, only the XY dimensions will be used,
the Z or M (3D and/or Measure) dimensions are dropped.
}
\examples{

## data.frame
df <- data.frame(polygonId = c(1,1,1,1),
  lineId = c(1,1,1,1),
  lon = c(-80.190, -66.118, -64.757, -80.190),
  lat = c(26.774, 18.466, 32.321, 26.774))
  
## on a data.frame, it will attemp to find the lon & lat columns
encode(df)

\dontrun{

## sf objects
library(sf)
nc <- sf::st_read(system.file("shape/nc.shp", package="sf"))

encoded <- encode(nc)

## strip attributes
encodedLite <- encode(nc, strip = TRUE)

}

}
\seealso{
\link{encodeCoordinates}
}
