% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topics.R
\name{topics_patch}
\alias{topics_patch}
\title{Updates an existing topic}
\usage{
topics_patch(
  topic,
  labels = NULL,
  message_storage_policy = NULL,
  kms_key_name = NULL,
  schema_settings = NULL,
  satisfies_pzs = NULL,
  message_retention_duration = NULL
)
}
\arguments{
\item{topic}{\code{character}, \code{Topic} Required, topic name or instance of a \code{Topic} object}

\item{labels}{\code{list} Key-value pairs for topic labels}

\item{message_storage_policy}{\code{MessageStoragePolicy} Policy constraining the set of Google Cloud
Platform regions where messages published to the topic may be stored.}

\item{kms_key_name}{\code{character} The resource name of the Cloud KMS CryptoKey to be used
to protect access to messages published on this topic.}

\item{schema_settings}{\code{SchemaSettings} An instance of a \code{SchemaSettings} object}

\item{satisfies_pzs}{\code{logical} Reserved for future use.}

\item{message_retention_duration}{\code{character} Indicates the minimum duration to retain
a message after it is published to the topic.}
}
\value{
An instance of the patched \code{Topic}
}
\description{
Updates an existing topic
}
\seealso{
Other Topic functions: 
\code{\link{topics_create}()},
\code{\link{topics_delete}()},
\code{\link{topics_exists}()},
\code{\link{topics_get}()},
\code{\link{topics_list_subscriptions}()},
\code{\link{topics_list}()},
\code{\link{topics_publish}()}
}
\concept{Topic functions}
