% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triggers.R
\name{gtm_triggers_revert}
\alias{gtm_triggers_revert}
\title{Reverts a trigger to its original state}
\usage{
gtm_triggers_revert(account_id, container_id, workspace_id, trigger_id)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{workspace_id}{Workspace Id}

\item{trigger_id}{Trigger Id}
}
\description{
This reverts a trigger back to its original, unmodified state.
}
\examples{

\dontrun{
accountId <- 1234567
containerId <- 7654321
workspaceId <- 10
triggerId <- 20

trugger <- gtm_triggers_revert(accountId, containerId, workspaceId, triggerId)

# Changes to trigger 20 have been reverted
}

}
\seealso{
\url{https://developers.google.com/tag-manager/api/v2/reference/accounts/containers/workspaces/triggers/revert}

Other trigger functions: 
\code{\link{gtm_triggers_create}()},
\code{\link{gtm_triggers_delete}()},
\code{\link{gtm_triggers_get}()},
\code{\link{gtm_triggers_list}()},
\code{\link{gtm_triggers_update}()}
}
\concept{trigger functions}
