% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gvisAnnotatedTimeLine.R
\name{gvisAnnotatedTimeLine}
\alias{gvisAnnotatedTimeLine}
\title{Google Annotated Time Line with R
\Sexpr{googleChartName <- "annotatedtimeline"}
\Sexpr{gvisChartName <- "gvisAnnotatedTimeLine"}}
\usage{
gvisAnnotatedTimeLine(data, datevar = "", numvar = "", idvar = "",
  titlevar = "", annotationvar = "", date.format = "\%Y/\%m/\%d",
  options = list(), chartid)
}
\arguments{
\item{data}{a \code{data.frame}. The data has to have at least two columns,
one with date information (\code{datevar}) and one numerical variable.}

\item{datevar}{column name of \code{data} which shows the date dimension.
The information has to be of class \code{\link{Date}} or \code{POSIX*} time
series.}

\item{numvar}{column name of \code{data} which shows the values to be
displayed against \code{datevar}. The information has to be
\code{\link{numeric}}.}

\item{idvar}{column name of \code{data} which identifies different groups of
the data. The information has to be of class \code{\link{character}} or
\code{\link{factor}}.}

\item{titlevar}{column name of \code{data} which shows the title of the
annotations. The information has to be of class \code{\link{character}} or
\code{\link{factor}}.  Missing information can be set to \code{NA}. See
section 'Details' for more details.}

\item{annotationvar}{column name of \code{data} which shows the annotation
text. The information has to be of class \code{\link{character}} or
\code{\link{factor}}. Missing information can be set to \code{NA}. See
section 'Details' for more details.}

\item{date.format}{if \code{datevar} is of class \code{\link{Date}} then
this argument specifies how the dates are reformatted to be used by
JavaScript.}

\item{options}{list of configuration options, see:

% START DYNAMIC CONTENT

\Sexpr[results=rd]{gsub("CHARTNAME",
googleChartName,
readLines(file.path(".", "inst",  "mansections",
"GoogleChartToolsURLConfigOptions.txt")))}

 \Sexpr[results=rd]{paste(readLines(file.path(".", "inst",
 "mansections", "gvisOptions.txt")))}}

\item{chartid}{character. If missing (default) a random chart id will be
generated based on chart type and \code{\link{tempfile}}}
}
\value{
\Sexpr[results=rd]{paste(gvisChartName)} returns list
of \code{\link{class}}
 \Sexpr[results=rd]{paste(readLines(file.path(".", "inst",
 "mansections", "gvisOutputStructure.txt")))}
}
\description{
The gvisAnnotatedTimeLine function reads a data.frame and creates text
output referring to the Google Visualisation API, which can be included into
a web page, or as a stand-alone page.
}
\details{
An annotated time line is an interactive time series line chart with
optional annotations. The chart is rendered within the browser using Flash.
}
\section{Warnings}{


Because of Flash security settings the chart might not work correctly when
accessed from a file location in the browser (e.g.,
file:///c:/webhost/myhost/myviz.html) rather than from a web server URL
(e.g. http://www.myhost.com/myviz.html). See the googleVis package vignette
and the Macromedia web site
(\url{http://www.macromedia.com/support/documentation/en/flashplayer/help/})
for more details.

Important: To use this visualization, you must specify the height and width
of the container element explicitly on your page. So, for example:
options=list(width="600px", height="350px")

Use code{\link{gvisAnnotationChart}} for a non-Flash version of this plot.
}
\examples{
## Please note that by default the googleVis plot command
## will open a browser window and requires Flash and Internet
## connection to display the visualisation.


data(Stock)
Stock
A1 <- gvisAnnotatedTimeLine(Stock, datevar="Date",
                           numvar="Value", idvar="Device",
                           titlevar="Title", annotationvar="Annotation",
                           options=list(displayAnnotations=TRUE,
                            legendPosition='newRow',
                            width="600px", height="350px")
                           )
plot(A1)

## Two Y-axis
A2 <- gvisAnnotatedTimeLine(Stock, datevar="Date",
                           numvar="Value", idvar="Device",
                           titlevar="Title", annotationvar="Annotation",
                           options=list(displayAnnotations=TRUE,
                            width="600px", height="350px", scaleColumns='[0,1]',
                            scaleType='allmaximized')
                          )
plot(A2)

## Zoom into the time window, no Y-axis ticks
A3 <- gvisAnnotatedTimeLine(Stock, datevar="Date",
                           numvar="Value", idvar="Device",
                           titlevar="Title", annotationvar="Annotation",
                           options=list(
                             width="600px", height="350px",
                            zoomStartTime=as.Date("2008-01-04"),
                            zoomEndTime=as.Date("2008-01-05"))
                          )
plot(A3)



## Colouring the area below the lines to create an area chart
A4 <- gvisAnnotatedTimeLine(Stock, datevar="Date",
                           numvar="Value", idvar="Device",
                           titlevar="Title", annotationvar="Annotation",
                           options=list(
                             width="600px", height="350px",
                             fill=10, displayExactValues=TRUE,
                             colors="['#0000ff','#00ff00']")
                           )

plot(A4)


## Data with POSIXct datetime variable
A5 <- gvisAnnotatedTimeLine(Andrew, datevar="Date/Time UTC",
                            numvar="Pressure_mb",
                            options=list(scaleType='maximized',
                                         width="600px", height="350px")
                            )

plot(A5)


\dontrun{

## Plot Apple's monthly stock prices since 1984

## Get current date
d <- Sys.time()
current.year <- format(d, "\%Y")
current.month <- format(d, "\%m")
current.day <- format(d, "\%d")

## Yahoo finance sets January to 00 hence:
month <- as.numeric(current.month)  - 1
month <- ifelse(month < 10, paste("0",month, sep=""), m)

## Get weekly stock prices from Apple Inc.
tckr <- 'AAPL'
yahoo <- 'http://ichart.finance.yahoo.com/table.csv'

fn <- sprintf('\%s?s=\%s&a=08&b=7&c=1984&d=\%s&e=\%s&f=\%s&g=w&ignore=.csv',
      yahoo, tckr, month, current.day, current.year)

## Get data from Yahoo! Finance
data <- read.csv(fn, colClasses=c("Date", rep("numeric",6)))

AAPL <- reshape(data[,c("Date", "Close", "Volume")], idvar="Date",
     		times=c("Close", "Volume"),
                timevar="Type",
                varying=list(c("Close", "Volume")),
                v.names="Value",
                direction="long")

## Calculate previous two years for zoom start time
lyd <- as.POSIXlt(as.Date(d))
lyd$year <- lyd$year-2
lyd <- as.Date(lyd)

aapl <- gvisAnnotatedTimeLine(AAPL, datevar="Date",
                           numvar="Value", idvar="Type",
                          options=list(
                            colors="['blue', 'lightblue']",
                            zoomStartTime=lyd,
                            zoomEndTime=as.Date(d),
                            legendPosition='newRow',
                            width="600px", height="400px", scaleColumns='[0,1]',
                            scaleType='allmaximized')
                           )

plot(aapl)
}
}
\author{
Markus Gesmann \email{markus.gesmann@gmail.com},

Diego de Castillo \email{decastillo@gmail.com}
}
\references{
Google Chart Tools API:
\Sexpr[results=rd]{gsub("CHARTNAME",
googleChartName,
readLines(file.path(".", "inst",  "mansections",
"GoogleChartToolsURL.txt")))}

% END DYNAMIC CONTENT
}
\seealso{
See also \code{\link{print.gvis}}, \code{\link{plot.gvis}} for printing and
plotting methods. Further see \code{\link{reshape}} for reshaping data, e.g.
from a wide format into a long format.
}
\keyword{iplot}

