% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_reshape_cellfeed.R
\name{gs_reshape_cellfeed}
\alias{gs_reshape_cellfeed}
\title{Reshape data from the "cell feed"}
\usage{
gs_reshape_cellfeed(x, literal = TRUE, ..., verbose = TRUE)
}
\arguments{
\item{x}{a data frame returned by \code{\link{gs_read_cellfeed}}}

\item{literal}{logical, indicating whether to work only with literal values
returned by the API or to consult alternate cell contents}

\item{...}{\strong{Optional} arguments to control data download, parsing, and
  reshaping; for most purposes, the defaults should be fine. Anything that is
  not listed here will be silently ignored.
\describe{
  \item{\code{progress}}{Logical. Whether to display download progress if in
  an interactive session.}
  \item{\code{col_types}}{Seize control of type conversion for variables.
  Passed straight through to
  \code{\link[readr:read_delim]{readr::read_csv}} or
  \code{\link[readr:type_convert]{readr::type_convert}}. Follow those links
  or read the \code{vignette("column-types")} for details.}
  \item{\code{locale, trim_ws, na}}{Specify locale, the fate of leading or
  trailing whitespace, or a character vector of strings that should become
  missing values. Passed straight through to
  \code{\link[readr:read_delim]{readr::read_csv}} or
  \code{\link[readr:type_convert]{readr::type_convert}}.}
  \item{\code{comment, skip, n_max}}{Specify a string used to identify
  comments, request to skip lines before reading data, or specify the
  maximum number of data rows to read.}
  \item{\code{col_names}}{Either \code{TRUE}, \code{FALSE} or a character
  vector of column names. If \code{TRUE}, the first row of the data rectangle
  will be used for names. If \code{FALSE}, column names will be X1, X2, etc.
  If a character vector, it will be used as column names. If the sheet
  contains column names and you just don't like them, specify \code{skip = 1}
  so they don't show up in your data.}
  \item{\code{check.names}}{Logical. Whether to run column names through
  \code{\link{make.names}} with \code{unique = TRUE}, just like
  \code{\link{read.table}} does. By default, \code{googlesheets} implements
  the \code{readr} data ingest philosophy, which leaves column names "as is",
  with one exception: data frames returned by \code{googlesheets} will have
  a name for each variable, even if we have to create one.}
}}

\item{verbose}{logical; do you want informative messages?}
}
\value{
a \code{data.frame} or, if \code{dplyr} is loaded, a
  \code{\link[dplyr]{tbl_df}}
}
\description{
Reshape data from the "cell feed", put it in a \code{tbl_df}, and do type
conversion. By default, assuming we're working with the same cells,
\code{gs_reshape_cellfeed} should return the same result as other read
functions. But when \code{literal = FALSE}, something different happens: we
attempt to deliver cell contents free of any numeric formatting. Try this if
numeric formatting of literal values is causing numeric data to come in as
character, to be undesirably rounded, or to be otherwise mangled. Remember
you can also control type conversion by using \code{...} to provide arguments
to \code{\link[readr:type_convert]{readr::type_convert}}. See the
\code{vignette("formulas-and-formatting")} for more details.
}
\examples{
\dontrun{
gap_ss <- gs_gap() # register the Gapminder example sheet
gs_read_cellfeed(gap_ss, "Asia", range = cell_rows(1:4))
gs_reshape_cellfeed(gs_read_cellfeed(gap_ss, "Asia", range = cell_rows(1:4)))
gs_reshape_cellfeed(gs_read_cellfeed(gap_ss, "Asia",
                                     range = cell_rows(2:4)),
                    col_names = FALSE)
gs_reshape_cellfeed(gs_read_cellfeed(gap_ss, "Asia",
                                     range = cell_rows(2:4)),
                    col_names = paste0("yo", 1:6))

ff_ss <- gs_ff() # register example sheet with formulas and formatted nums
ff_cf <- gs_read_cellfeed(ff_ss)
gs_reshape_cellfeed(ff_cf) # almost all vars are character
gs_reshape_cellfeed(ff_cf, literal = FALSE) # more vars are numeric
}
}
\seealso{
Other data consumption functions: \code{\link{gs_read_cellfeed}},
  \code{\link{gs_read_csv}},
  \code{\link{gs_read_listfeed}}, \code{\link{gs_read}},
  \code{\link{gs_simplify_cellfeed}}
}

