% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs4_auth.R
\name{gs4_token}
\alias{gs4_token}
\title{Produce configured token}
\usage{
gs4_token()
}
\value{
A \code{request} object (an S3 class provided by \link[httr:httr-package]{httr}).
}
\description{
For internal use or for those programming around the Sheets API.
Returns a token pre-processed with \code{\link[httr:config]{httr::config()}}. Most users
do not need to handle tokens "by hand" or, even if they need some
control, \code{\link[=gs4_auth]{gs4_auth()}} is what they need. If there is no current
token, \code{\link[=gs4_auth]{gs4_auth()}} is called to either load from cache or
initiate OAuth2.0 flow.
If auth has been deactivated via \code{\link[=gs4_deauth]{gs4_deauth()}}, \code{gs4_token()}
returns \code{NULL}.
}
\examples{
if (gs4_has_token()) {
  req <- request_generate(
    "sheets.spreadsheets.get",
    list(spreadsheetId = "abc"),
    token = gs4_token()
  )
  req
}
}
\seealso{
Other low-level API functions: 
\code{\link{gs4_has_token}()},
\code{\link{request_generate}()},
\code{\link{request_make}()}
}
\concept{low-level API functions}
