% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_map_layer_geojson.R
\name{add_geojson}
\alias{add_geojson}
\title{Add GeoJson}
\usage{
add_geojson(map, data = get_map_data(map), layer_id = NULL, style = NULL,
  mouse_over = FALSE, update_map_view = TRUE)
}
\arguments{
\item{map}{a googleway map object created from \code{google_map()}}

\item{data}{A character string or geoJSON literal of correctly formatted geoJSON}

\item{layer_id}{single value specifying an id for the layer.}

\item{style}{Style options for the geoJSON. See details}

\item{mouse_over}{logical indicating if a feature should be highlighted when
the mouse passess over}

\item{update_map_view}{logical specifying if the map should re-centre according
to the geoJSON}
}
\description{
Add GeoJson
}
\details{
The style of the geoJSON features can be defined inside the geoJSON itself,
or specified as a JSON string or R list that's used to style all the features the same

To use the properties in the geoJSON to define the styles, set the \code{style}
argument to a JSON string or a named list, where each name is one of

All Geometries

\itemize{
  \item{clickable}
  \item{visible}
  \item{zIndex}
}

Point Geometries

\itemize{
  \item{cursor}
  \item{icon}
  \item{shape}
  \item{title}
}

Line Geometries
\itemize{
  \item{strokeColor}
  \item{strokeOpacity}
  \item{strokeWeight}
}

Polygon Geometries (Line Geometries, plus)
\itemize{
  \item{fillColor}
  \item{fillOpacity}
}

and where the values are the the properties of the geoJSON that contain the relevant style
for those properties.

To style all the features the same, supply a JSON string or R list that
defines a value for each of the style options (listed above)

See examples.
}
\examples{
\dontrun{


## use the properties inside the geoJSON to style each feature
google_map(key = map_key) \%>\%
  add_geojson(data = geo_melbourne)

## use a JSON string to style all features
style <- '{ "fillColor" : "green" , "strokeColor" : "black", "strokeWeight" : 0.5}'
google_map(key = map_key) \%>\%
  add_geojson(data = geo_melbourne, style = style)


## use a named list to style all features
style <- list(fillColor = "red" , strokeColor = "blue", strokeWeight = 0.5)
google_map(key = map_key) \%>\%
  add_geojson(data = geo_melbourne, style = style)

## GeoJSON from a URL
url <- 'https://storage.googleapis.com/mapsdevsite/json/google.json'
google_map(key = map_key) \%>\%
  add_geojson(data = url, mouse_over = T)

}

}
