% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11-grafos-NPdif.R
\encoding{UTF-8}
\name{plot_cover}
\alias{plot_cover}
\title{Vertex cover plotting}
\usage{
plot_cover(X, G)
}
\arguments{
\item{X}{Cover to be plotted; an output list returned by some
cover-building function, see below.}

\item{G}{Graph on which to superimpose the cover.}
}
\value{
This function is called for its side effect of plotting.
}
\description{
Plot of a vertex cover in a graph.
}
\details{
It plots a graph, then superimposes a vertex cover in a different
color.  It also draws the covered edges, to help in detecting
non-covers by inspection.
}
\examples{
set.seed(1)
g <- sample_gnp(25, p=0.25)   # Random graph
X1 <- build_cover_greedy(g)
plot_cover(X1, g)

st <- 1:5   # Not a vertex cover
plot_cover(list(set = st, size = length(st)), g)  # See covered edges

}
\seealso{
\link{is_cover} checks if a vertex subset is a vertex cover,
\link{build_cover_greedy} builds a cover using a greedy heuristic,
\link{build_cover_approx} builds a cover using a 2-approximation
algorithm, \link{improve_cover_flip} improves a cover using local
search, \link{search_cover_random} looks for a random cover of
fixed size, \link{search_cover_ants} looks for a random cover using
a version of the ant-colony optimization heuristic,
\link{find_cover_BB} finds covers using a branch-and-bound
technique.
}
\author{
Cesar Asensio
}
