% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keys.R
\name{gpg_keys}
\alias{gpg_keys}
\alias{gpg_import}
\alias{gpg_recv}
\alias{gpg_send}
\alias{gpg_delete}
\alias{gpg_export}
\alias{gpg_list_keys}
\alias{gpg_list_signatures}
\title{GPG keyring management}
\usage{
gpg_import(file)

gpg_recv(id, search = NULL, keyserver = NULL)

gpg_send(id, keyserver = NULL)

gpg_delete(id, secret = FALSE)

gpg_export(id, secret = FALSE)

gpg_list_keys(search = "", secret = FALSE)

gpg_list_signatures(id)
}
\arguments{
\item{file}{path to the key file or raw vector with key data}

\item{id}{unique ID of the pubkey to import (starts with \verb{0x}). Alternatively you
can specify a \code{search} string.}

\item{search}{string with name or email address to match the key info.}

\item{keyserver}{address of http keyserver. Default behavior is to try several
commonly used servers (MIT, Ubuntu, GnuPG, Surfnet)}

\item{secret}{set to \code{TRUE} to list/export/delete private (secret) keys}
}
\description{
Signing or encrypting with GPG require that the keys are stored in your
personal keyring. Use \link{gpg_version} to see which keyring (home dir)
you are using. Also see \link{gpg_keygen} for generating a new key.
}
\examples{
\donttest{
# Submit key to a specific key server.
gpg_send("87CC261267801A17", "https://keys.openpgp.org")
# Submit key to many key servers.
gpg_send("87CC261267801A17")
}
}
\seealso{
Other gpg: 
\code{\link{gpg_encrypt}()},
\code{\link{gpg_keygen}()},
\code{\link{gpg_sign}()}
}
\concept{gpg}
