# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

cpp_vclMatrix_custom_chol <- function(ptrB, BisVCL, upper, sourceCode, max_local_size, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_vclMatrix_custom_chol', PACKAGE = 'gpuR', ptrB, BisVCL, upper, sourceCode, max_local_size, type_flag, ctx_id))
}

initContexts <- function() {
    invisible(.Call('gpuR_initContexts', PACKAGE = 'gpuR'))
}

#' @title Available OpenCL Contexts
#' @description Provide a data.frame of available OpenCL contexts and
#' associated information.
#' @return data.frame containing the following fields
#' @return \item{context}{Integer identifying context}
#' @return \item{platform}{Character string listing OpenCL platform}
#' @return \item{platform_index}{Integer identifying platform}
#' @return \item{device}{Character string listing device name}
#' @return \item{device_index}{Integer identifying device}
#' @return \item{device_type}{Character string labeling device (e.g. gpu)}
#' @export
listContexts <- function() {
    .Call('gpuR_listContexts', PACKAGE = 'gpuR')
}

#' @title Current Context
#' @description Get current context index
#' @return An integer reflecting the context listed in \link{listContexts}
#' @export
currentContext <- function() {
    .Call('gpuR_currentContext', PACKAGE = 'gpuR')
}

cpp_setContext <- function(id) {
    invisible(.Call('gpuR_cpp_setContext', PACKAGE = 'gpuR', id))
}

cpp_deviceType <- function(platform_idx_, gpu_idx_) {
    .Call('gpuR_cpp_deviceType', PACKAGE = 'gpuR', platform_idx_, gpu_idx_)
}

cpp_detectGPUs <- function(platform_idx) {
    .Call('gpuR_cpp_detectGPUs', PACKAGE = 'gpuR', platform_idx)
}

cpp_gpuInfo <- function(platform_idx_, gpu_idx_) {
    .Call('gpuR_cpp_gpuInfo', PACKAGE = 'gpuR', platform_idx_, gpu_idx_)
}

cpp_cpuInfo <- function(platform_idx_, cpu_idx_) {
    .Call('gpuR_cpp_cpuInfo', PACKAGE = 'gpuR', platform_idx_, cpu_idx_)
}

#' @title Current Device Information
#' @description Check current device information
#' @return list containing
#' @return \item{device}{Character string of device name}
#' @return \item{device_index}{Integer identifying device}
#' @return \item{device_type}{Character string identifying device type (e.g. gpu)}
#' @export
currentDevice <- function() {
    .Call('gpuR_currentDevice', PACKAGE = 'gpuR')
}

cpp_detectCPUs <- function(platform_idx) {
    .Call('gpuR_cpp_detectCPUs', PACKAGE = 'gpuR', platform_idx)
}

cpp_deepcopy_gpuMatrix <- function(ptrA, type_flag) {
    .Call('gpuR_cpp_deepcopy_gpuMatrix', PACKAGE = 'gpuR', ptrA, type_flag)
}

cpp_cbind_gpuMatrix <- function(ptrA, ptrB, type_flag) {
    .Call('gpuR_cpp_cbind_gpuMatrix', PACKAGE = 'gpuR', ptrA, ptrB, type_flag)
}

cpp_rbind_gpuMatrix <- function(ptrA, ptrB, type_flag) {
    .Call('gpuR_cpp_rbind_gpuMatrix', PACKAGE = 'gpuR', ptrA, ptrB, type_flag)
}

cpp_deepcopy_gpuVector <- function(ptrA, type_flag) {
    .Call('gpuR_cpp_deepcopy_gpuVector', PACKAGE = 'gpuR', ptrA, type_flag)
}

sliceGPUvec <- function(ptrA, start, end, type_flag) {
    .Call('gpuR_sliceGPUvec', PACKAGE = 'gpuR', ptrA, start, end, type_flag)
}

gpuMatBlock <- function(ptrA, rowStart, rowEnd, colStart, colEnd, type_flag) {
    .Call('gpuR_gpuMatBlock', PACKAGE = 'gpuR', ptrA, rowStart, rowEnd, colStart, colEnd, type_flag)
}

GetVecElement <- function(ptrA, idx, type_flag) {
    .Call('gpuR_GetVecElement', PACKAGE = 'gpuR', ptrA, idx, type_flag)
}

SetVecElement <- function(ptrA, idx, value, type_flag) {
    invisible(.Call('gpuR_SetVecElement', PACKAGE = 'gpuR', ptrA, idx, value, type_flag))
}

SetMatRow <- function(ptrA, idx, value, type_flag) {
    invisible(.Call('gpuR_SetMatRow', PACKAGE = 'gpuR', ptrA, idx, value, type_flag))
}

SetMatCol <- function(ptrA, idx, value, type_flag) {
    invisible(.Call('gpuR_SetMatCol', PACKAGE = 'gpuR', ptrA, idx, value, type_flag))
}

SetMatElement <- function(ptrA, nr, nc, value, type_flag) {
    invisible(.Call('gpuR_SetMatElement', PACKAGE = 'gpuR', ptrA, nr, nc, value, type_flag))
}

GetMatRow <- function(ptrA, idx, type_flag) {
    .Call('gpuR_GetMatRow', PACKAGE = 'gpuR', ptrA, idx, type_flag)
}

GetMatCol <- function(ptrA, idx, type_flag) {
    .Call('gpuR_GetMatCol', PACKAGE = 'gpuR', ptrA, idx, type_flag)
}

GetMatElement <- function(ptrA, nr, nc, type_flag) {
    .Call('gpuR_GetMatElement', PACKAGE = 'gpuR', ptrA, nr, nc, type_flag)
}

sexpVecToEigenVecXptr <- function(ptrA, size, type_flag) {
    .Call('gpuR_sexpVecToEigenVecXptr', PACKAGE = 'gpuR', ptrA, size, type_flag)
}

sexpVecToEigenXptr <- function(ptrA, nr, nc, type_flag) {
    .Call('gpuR_sexpVecToEigenXptr', PACKAGE = 'gpuR', ptrA, nr, nc, type_flag)
}

initScalarEigenXptr <- function(scalar, nr, nc, type_flag) {
    .Call('gpuR_initScalarEigenXptr', PACKAGE = 'gpuR', scalar, nr, nc, type_flag)
}

getRmatEigenAddress <- function(ptrA, nr, nc, type_flag) {
    .Call('gpuR_getRmatEigenAddress', PACKAGE = 'gpuR', ptrA, nr, nc, type_flag)
}

EigenVecXPtrToMapEigenVec <- function(ptrA, type_flag) {
    .Call('gpuR_EigenVecXPtrToMapEigenVec', PACKAGE = 'gpuR', ptrA, type_flag)
}

MatXptrToMatSEXP <- function(ptrA, type_flag) {
    .Call('gpuR_MatXptrToMatSEXP', PACKAGE = 'gpuR', ptrA, type_flag)
}

emptyEigenVecXptr <- function(size, type_flag) {
    .Call('gpuR_emptyEigenVecXptr', PACKAGE = 'gpuR', size, type_flag)
}

emptyEigenXptr <- function(nr, nc, type_flag) {
    .Call('gpuR_emptyEigenXptr', PACKAGE = 'gpuR', nr, nc, type_flag)
}

setCols <- function(ptrA, names, type_flag) {
    invisible(.Call('gpuR_setCols', PACKAGE = 'gpuR', ptrA, names, type_flag))
}

getCols <- function(ptrA, type_flag) {
    .Call('gpuR_getCols', PACKAGE = 'gpuR', ptrA, type_flag)
}

cpp_gpuMatrix_get_diag <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_get_diag', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_gpuMat_gpuVec_set_diag <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMat_gpuVec_set_diag', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_gpuMatrix_custom_igemm <- function(ptrA_, AisVCL, ptrB_, BisVCL, ptrC_, CisVCL, sourceCode_, max_local_size, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_custom_igemm', PACKAGE = 'gpuR', ptrA_, AisVCL, ptrB_, BisVCL, ptrC_, CisVCL, sourceCode_, max_local_size, ctx_id))
}

#' @title Detect Number of Platforms
#' @description Find out how many OpenCL enabled platforms are available.
#' @return An integer value representing the number of platforms available.
#' @seealso \link{detectGPUs}
#' @export
detectPlatforms <- function() {
    .Call('gpuR_detectPlatforms', PACKAGE = 'gpuR')
}

#' @title Return Current Platform
#' @description Find out which platform is currently in use
#' @return \item{platform}{Name of the current platform}
#' @return \item{platform_index}{Index of current platform}
#' @seealso \link{detectPlatforms}
#' @export
currentPlatform <- function() {
    .Call('gpuR_currentPlatform', PACKAGE = 'gpuR')
}

cpp_platformInfo <- function(platform_idx_) {
    .Call('gpuR_cpp_platformInfo', PACKAGE = 'gpuR', platform_idx_)
}

cpp_vclMatrix_set_row_order <- function(ptrA, ptrB, AisVCL, BisVCL, indices, sourceCode, max_local_size, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_vclMatrix_set_row_order', PACKAGE = 'gpuR', ptrA, ptrB, AisVCL, BisVCL, indices, sourceCode, max_local_size, type_flag, ctx_id))
}

cpp_gpuMatrix_solve <- function(ptrA, ptrB, AisVCL, BisVCL, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_solve', PACKAGE = 'gpuR', ptrA, ptrB, AisVCL, BisVCL, type_flag, ctx_id))
}

truncIntgpuMat <- function(ptrA_, nr, nc) {
    .Call('gpuR_truncIntgpuMat', PACKAGE = 'gpuR', ptrA_, nr, nc)
}

truncFloatgpuMat <- function(ptrA_, nr, nc) {
    .Call('gpuR_truncFloatgpuMat', PACKAGE = 'gpuR', ptrA_, nr, nc)
}

truncDoublegpuMat <- function(ptrA_, nr, nc) {
    .Call('gpuR_truncDoublegpuMat', PACKAGE = 'gpuR', ptrA_, nr, nc)
}

vcl_dncol <- function(ptrA) {
    .Call('gpuR_vcl_dncol', PACKAGE = 'gpuR', ptrA)
}

vcl_fncol <- function(ptrA) {
    .Call('gpuR_vcl_fncol', PACKAGE = 'gpuR', ptrA)
}

vcl_incol <- function(ptrA) {
    .Call('gpuR_vcl_incol', PACKAGE = 'gpuR', ptrA)
}

vcl_dnrow <- function(ptrA) {
    .Call('gpuR_vcl_dnrow', PACKAGE = 'gpuR', ptrA)
}

vcl_fnrow <- function(ptrA) {
    .Call('gpuR_vcl_fnrow', PACKAGE = 'gpuR', ptrA)
}

vcl_inrow <- function(ptrA) {
    .Call('gpuR_vcl_inrow', PACKAGE = 'gpuR', ptrA)
}

cpp_vclVector_size <- function(ptrA, type_flag) {
    .Call('gpuR_cpp_vclVector_size', PACKAGE = 'gpuR', ptrA, type_flag)
}

cpp_gpuVector_size <- function(ptrA, type_flag) {
    .Call('gpuR_cpp_gpuVector_size', PACKAGE = 'gpuR', ptrA, type_flag)
}

cpp_gpuMatrix_max <- function(ptrA, type_flag) {
    .Call('gpuR_cpp_gpuMatrix_max', PACKAGE = 'gpuR', ptrA, type_flag)
}

cpp_gpuMatrix_min <- function(ptrA, type_flag) {
    .Call('gpuR_cpp_gpuMatrix_min', PACKAGE = 'gpuR', ptrA, type_flag)
}

cpp_gpuMatrix_nrow <- function(ptrA, type_flag) {
    .Call('gpuR_cpp_gpuMatrix_nrow', PACKAGE = 'gpuR', ptrA, type_flag)
}

cpp_gpuMatrix_ncol <- function(ptrA, type_flag) {
    .Call('gpuR_cpp_gpuMatrix_ncol', PACKAGE = 'gpuR', ptrA, type_flag)
}

cpp_identity_vclMatrix <- function(ptrA, type_flag) {
    invisible(.Call('gpuR_cpp_identity_vclMatrix', PACKAGE = 'gpuR', ptrA, type_flag))
}

cpp_vclMatrix_get_diag <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_get_diag', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclMat_vclVec_set_diag <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclMat_vclVec_set_diag', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_deepcopy_vclMatrix <- function(ptrA, type_flag, ctx_id, source) {
    .Call('gpuR_cpp_deepcopy_vclMatrix', PACKAGE = 'gpuR', ptrA, type_flag, ctx_id, source)
}

cpp_deepcopy_vclVector <- function(ptrA, type_flag, ctx_id) {
    .Call('gpuR_cpp_deepcopy_vclVector', PACKAGE = 'gpuR', ptrA, type_flag, ctx_id)
}

cpp_vclVector_slice <- function(ptrA, start, end, type_flag) {
    .Call('gpuR_cpp_vclVector_slice', PACKAGE = 'gpuR', ptrA, start, end, type_flag)
}

cpp_vclMatrix_block <- function(ptrA, rowStart, rowEnd, colStart, colEnd, type_flag) {
    .Call('gpuR_cpp_vclMatrix_block', PACKAGE = 'gpuR', ptrA, rowStart, rowEnd, colStart, colEnd, type_flag)
}

cpp_cbind_vclMatrix <- function(ptrA, ptrB, type_flag, ctx_id) {
    .Call('gpuR_cpp_cbind_vclMatrix', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id)
}

cpp_rbind_vclMatrix <- function(ptrA, ptrB, type_flag, ctx_id) {
    .Call('gpuR_cpp_rbind_vclMatrix', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id)
}

cpp_sexp_mat_to_vclMatrix <- function(ptrA, type_flag, ctx_id) {
    .Call('gpuR_cpp_sexp_mat_to_vclMatrix', PACKAGE = 'gpuR', ptrA, type_flag, ctx_id)
}

VCLtoMatSEXP <- function(ptrA, type_flag) {
    .Call('gpuR_VCLtoMatSEXP', PACKAGE = 'gpuR', ptrA, type_flag)
}

cpp_zero_vclMatrix <- function(nr, nc, type_flag, ctx_id) {
    .Call('gpuR_cpp_zero_vclMatrix', PACKAGE = 'gpuR', nr, nc, type_flag, ctx_id)
}

cpp_scalar_vclMatrix <- function(scalar, nr, nc, type_flag, ctx_id) {
    .Call('gpuR_cpp_scalar_vclMatrix', PACKAGE = 'gpuR', scalar, nr, nc, type_flag, ctx_id)
}

vclSetCol <- function(ptrA, nc, newdata, type_flag) {
    invisible(.Call('gpuR_vclSetCol', PACKAGE = 'gpuR', ptrA, nc, newdata, type_flag))
}

vclSetRow <- function(ptrA, nr, newdata, type_flag) {
    invisible(.Call('gpuR_vclSetRow', PACKAGE = 'gpuR', ptrA, nr, newdata, type_flag))
}

vclSetElement <- function(ptrA, nr, nc, newdata, type_flag) {
    invisible(.Call('gpuR_vclSetElement', PACKAGE = 'gpuR', ptrA, nr, nc, newdata, type_flag))
}

vclSetMatrix <- function(ptrA, newdata, type_flag, ctx_id) {
    invisible(.Call('gpuR_vclSetMatrix', PACKAGE = 'gpuR', ptrA, newdata, type_flag, ctx_id))
}

vclSetVCLMatrix <- function(ptrA, newdata, type_flag, ctx_id) {
    invisible(.Call('gpuR_vclSetVCLMatrix', PACKAGE = 'gpuR', ptrA, newdata, type_flag, ctx_id))
}

vclGetCol <- function(ptrA, nc, type_flag, ctx_id) {
    .Call('gpuR_vclGetCol', PACKAGE = 'gpuR', ptrA, nc, type_flag, ctx_id)
}

vclGetRow <- function(ptrA, nr, type_flag, ctx_id) {
    .Call('gpuR_vclGetRow', PACKAGE = 'gpuR', ptrA, nr, type_flag, ctx_id)
}

vclGetElement <- function(ptrA, nr, nc, type_flag) {
    .Call('gpuR_vclGetElement', PACKAGE = 'gpuR', ptrA, nr, nc, type_flag)
}

vclVecGetElement <- function(ptrA, idx, type_flag) {
    .Call('gpuR_vclVecGetElement', PACKAGE = 'gpuR', ptrA, idx, type_flag)
}

vclVecSetElement <- function(ptrA, idx, newdata, type_flag) {
    invisible(.Call('gpuR_vclVecSetElement', PACKAGE = 'gpuR', ptrA, idx, newdata, type_flag))
}

vclSetVector <- function(ptrA, newdata, type_flag, ctx_id) {
    invisible(.Call('gpuR_vclSetVector', PACKAGE = 'gpuR', ptrA, newdata, type_flag, ctx_id))
}

vclSetVCLVector <- function(ptrA, newdata, type_flag) {
    invisible(.Call('gpuR_vclSetVCLVector', PACKAGE = 'gpuR', ptrA, newdata, type_flag))
}

vectorToVCL <- function(ptrA, type_flag, ctx_id) {
    .Call('gpuR_vectorToVCL', PACKAGE = 'gpuR', ptrA, type_flag, ctx_id)
}

vectorToMatVCL <- function(ptrA, nr, nc, type_flag, ctx_id) {
    .Call('gpuR_vectorToMatVCL', PACKAGE = 'gpuR', ptrA, nr, nc, type_flag, ctx_id)
}

vclMatTovclVec <- function(ptrA, type_flag) {
    .Call('gpuR_vclMatTovclVec', PACKAGE = 'gpuR', ptrA, type_flag)
}

VCLtoVecSEXP <- function(ptrA, type_flag) {
    .Call('gpuR_VCLtoVecSEXP', PACKAGE = 'gpuR', ptrA, type_flag)
}

emptyVecVCL <- function(length, type_flag, ctx_id) {
    .Call('gpuR_emptyVecVCL', PACKAGE = 'gpuR', length, type_flag, ctx_id)
}

setVCLcols <- function(ptrA, names, type_flag) {
    invisible(.Call('gpuR_setVCLcols', PACKAGE = 'gpuR', ptrA, names, type_flag))
}

getVCLcols <- function(ptrA, type_flag) {
    .Call('gpuR_getVCLcols', PACKAGE = 'gpuR', ptrA, type_flag)
}

cpp_gpuMatrix_elem_prod <- function(ptrA, ptrB, ptrC, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_prod', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, type_flag, ctx_id))
}

cpp_gpuMatrix_scalar_prod <- function(ptrC, scalar, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_scalar_prod', PACKAGE = 'gpuR', ptrC, scalar, type_flag, ctx_id))
}

cpp_gpuMatrix_scalar_div <- function(ptrC, B_scalar, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_scalar_div', PACKAGE = 'gpuR', ptrC, B_scalar, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_div <- function(ptrA, ptrB, ptrC, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_div', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_pow <- function(ptrA, ptrB, ptrC, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_pow', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, type_flag, ctx_id))
}

cpp_gpuMatrix_scalar_pow <- function(ptrA, scalar, ptrC, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_scalar_pow', PACKAGE = 'gpuR', ptrA, scalar, ptrC, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_sin <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_sin', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_asin <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_asin', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_sinh <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_sinh', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_cos <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_cos', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_acos <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_acos', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_cosh <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_cosh', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_tan <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_tan', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_atan <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_atan', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_tanh <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_tanh', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_log <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_log', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_log_base <- function(ptrA, ptrB, base, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_log_base', PACKAGE = 'gpuR', ptrA, ptrB, base, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_log10 <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_log10', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_exp <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_exp', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_abs <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_abs', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuMatrix_axpy <- function(alpha, ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_axpy', PACKAGE = 'gpuR', alpha, ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuMatrix_unary_axpy <- function(ptrA, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_unary_axpy', PACKAGE = 'gpuR', ptrA, type_flag, ctx_id))
}

cpp_vclMatrix_axpy <- function(alpha, ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_axpy', PACKAGE = 'gpuR', alpha, ptrA, ptrB, type_flag))
}

cpp_vclMatrix_unary_axpy <- function(ptrA, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_vclMatrix_unary_axpy', PACKAGE = 'gpuR', ptrA, type_flag, ctx_id))
}

cpp_vclMatrix_elem_prod <- function(ptrA, ptrB, ptrC, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_prod', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, type_flag))
}

cpp_vclMatrix_scalar_prod <- function(ptrC, B_scalar, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_scalar_prod', PACKAGE = 'gpuR', ptrC, B_scalar, type_flag))
}

cpp_vclMatrix_elem_div <- function(ptrA, ptrB, ptrC, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_div', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, type_flag))
}

cpp_vclMatrix_scalar_div <- function(ptrC, B_scalar, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_scalar_div', PACKAGE = 'gpuR', ptrC, B_scalar, type_flag))
}

cpp_vclMatrix_elem_pow <- function(ptrA, ptrB, ptrC, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_pow', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, type_flag))
}

cpp_vclMatrix_scalar_pow <- function(ptrA, scalar, ptrC, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_vclMatrix_scalar_pow', PACKAGE = 'gpuR', ptrA, scalar, ptrC, type_flag, ctx_id))
}

cpp_vclMatrix_elem_sin <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_sin', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclMatrix_elem_asin <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_asin', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclMatrix_elem_sinh <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_sinh', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclMatrix_elem_cos <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_cos', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclMatrix_elem_acos <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_acos', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclMatrix_elem_cosh <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_cosh', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclMatrix_elem_tan <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_tan', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclMatrix_elem_atan <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_atan', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclMatrix_elem_tanh <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_tanh', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclMatrix_elem_log <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_log', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclMatrix_elem_log10 <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_log10', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclMatrix_elem_log_base <- function(ptrA, ptrB, base, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_log_base', PACKAGE = 'gpuR', ptrA, ptrB, base, type_flag))
}

cpp_vclMatrix_elem_exp <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_exp', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclMatrix_elem_abs <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_abs', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclMatrix_max <- function(ptrA, type_flag) {
    .Call('gpuR_cpp_vclMatrix_max', PACKAGE = 'gpuR', ptrA, type_flag)
}

cpp_vclMatrix_min <- function(ptrA, type_flag) {
    .Call('gpuR_cpp_vclMatrix_min', PACKAGE = 'gpuR', ptrA, type_flag)
}

cpp_gpuVector_axpy <- function(alpha, ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_axpy', PACKAGE = 'gpuR', alpha, ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuVector_unary_axpy <- function(ptrA, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_unary_axpy', PACKAGE = 'gpuR', ptrA, type_flag, ctx_id))
}

cpp_gpuVector_inner_prod <- function(ptrA, ptrB, type_flag, ctx_id) {
    .Call('gpuR_cpp_gpuVector_inner_prod', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id)
}

cpp_gpuVector_outer_prod <- function(ptrA, ptrB, ptrC, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_outer_prod', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, type_flag, ctx_id))
}

cpp_gpuVector_elem_prod <- function(ptrA, ptrB, ptrC, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_prod', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, type_flag, ctx_id))
}

cpp_gpuVector_scalar_prod <- function(ptrC, scalar, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_scalar_prod', PACKAGE = 'gpuR', ptrC, scalar, type_flag, ctx_id))
}

cpp_gpuVector_elem_div <- function(ptrA, ptrB, ptrC, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_div', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, type_flag, ctx_id))
}

cpp_gpuVector_scalar_div <- function(ptrC, scalar, order, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_scalar_div', PACKAGE = 'gpuR', ptrC, scalar, order, type_flag, ctx_id))
}

cpp_gpuVector_elem_pow <- function(ptrA, ptrB, ptrC, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_pow', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, type_flag, ctx_id))
}

cpp_gpuVector_scalar_pow <- function(ptrA, scalar, ptrC, order, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_scalar_pow', PACKAGE = 'gpuR', ptrA, scalar, ptrC, order, type_flag, ctx_id))
}

cpp_gpuVector_elem_sin <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_sin', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuVector_elem_asin <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_asin', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuVector_elem_sinh <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_sinh', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuVector_elem_cos <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_cos', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuVector_elem_acos <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_acos', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuVector_elem_cosh <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_cosh', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuVector_elem_tan <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_tan', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuVector_elem_atan <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_atan', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuVector_elem_tanh <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_tanh', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuVector_elem_log10 <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_log10', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuVector_elem_log <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_log', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuVector_elem_log_base <- function(ptrA, ptrB, base, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_log_base', PACKAGE = 'gpuR', ptrA, ptrB, base, type_flag, ctx_id))
}

cpp_gpuVector_elem_exp <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_exp', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuVector_elem_abs <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_abs', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuVector_max <- function(ptrA, type_flag, ctx_id) {
    .Call('gpuR_cpp_gpuVector_max', PACKAGE = 'gpuR', ptrA, type_flag, ctx_id)
}

cpp_gpuVector_min <- function(ptrA, type_flag, ctx_id) {
    .Call('gpuR_cpp_gpuVector_min', PACKAGE = 'gpuR', ptrA, type_flag, ctx_id)
}

cpp_vclVector_axpy <- function(alpha, ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_axpy', PACKAGE = 'gpuR', alpha, ptrA, ptrB, type_flag))
}

cpp_vclVector_unary_axpy <- function(ptrA, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_unary_axpy', PACKAGE = 'gpuR', ptrA, type_flag))
}

cpp_vclVector_inner_prod <- function(ptrA, ptrB, type_flag) {
    .Call('gpuR_cpp_vclVector_inner_prod', PACKAGE = 'gpuR', ptrA, ptrB, type_flag)
}

cpp_vclVector_outer_prod <- function(ptrA, ptrB, ptrC, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_outer_prod', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, type_flag))
}

cpp_vclVector_elem_prod <- function(ptrA, ptrB, ptrC, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_prod', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, type_flag))
}

cpp_vclVector_scalar_prod <- function(ptrC, scalar, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_scalar_prod', PACKAGE = 'gpuR', ptrC, scalar, type_flag))
}

cpp_vclVector_elem_div <- function(ptrA, ptrB, ptrC, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_div', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, type_flag))
}

cpp_vclVector_scalar_div <- function(ptrC, scalar, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_scalar_div', PACKAGE = 'gpuR', ptrC, scalar, type_flag))
}

cpp_vclVector_elem_pow <- function(ptrA, ptrB, ptrC, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_pow', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, type_flag))
}

cpp_vclVector_scalar_pow <- function(ptrA, scalar, ptrC, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_scalar_pow', PACKAGE = 'gpuR', ptrA, scalar, ptrC, type_flag))
}

cpp_vclVector_elem_sin <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_sin', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclVector_elem_asin <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_asin', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclVector_elem_sinh <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_sinh', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclVector_elem_cos <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_cos', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclVector_elem_acos <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_acos', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclVector_elem_cosh <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_cosh', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclVector_elem_tan <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_tan', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclVector_elem_atan <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_atan', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclVector_elem_tanh <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_tanh', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclVector_elem_log <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_log', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclVector_elem_log10 <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_log10', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclVector_elem_log_base <- function(ptrA, ptrB, R_base, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_log_base', PACKAGE = 'gpuR', ptrA, ptrB, R_base, type_flag))
}

cpp_vclVector_elem_exp <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_exp', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclVector_elem_abs <- function(ptrA, ptrC, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_abs', PACKAGE = 'gpuR', ptrA, ptrC, type_flag))
}

cpp_vclVector_max <- function(ptrA, type_flag) {
    .Call('gpuR_cpp_vclVector_max', PACKAGE = 'gpuR', ptrA, type_flag)
}

cpp_vclVector_min <- function(ptrA, type_flag) {
    .Call('gpuR_cpp_vclVector_min', PACKAGE = 'gpuR', ptrA, type_flag)
}

cpp_gpuMatrix_gemm <- function(ptrA, ptrB, ptrC, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_gemm', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, type_flag, ctx_id))
}

cpp_gpuMatrix_crossprod <- function(ptrA, ptrB, ptrC, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_crossprod', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, type_flag, ctx_id))
}

cpp_gpuMatrix_tcrossprod <- function(ptrA, ptrB, ptrC, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_tcrossprod', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, type_flag, ctx_id))
}

cpp_gpuMatrix_transpose <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_transpose', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_vclMatrix_gemm <- function(ptrA, ptrB, ptrC, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_gemm', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, type_flag))
}

cpp_vclMatrix_crossprod <- function(ptrA, ptrB, ptrC, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_crossprod', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, type_flag))
}

cpp_vclMatrix_tcrossprod <- function(ptrA, ptrB, ptrC, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_tcrossprod', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, type_flag))
}

cpp_vclMatrix_transpose <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_transpose', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_gpu_eigen <- function(Am, Qm, eigenvalues, symmetric, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpu_eigen', PACKAGE = 'gpuR', Am, Qm, eigenvalues, symmetric, type_flag, ctx_id))
}

cpp_vcl_eigen <- function(Am, Qm, eigenvalues, symmetric, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_vcl_eigen', PACKAGE = 'gpuR', Am, Qm, eigenvalues, symmetric, type_flag, ctx_id))
}

cpp_gpuR_qr <- function(ptrA, isVCL, type_flag, ctx_id) {
    .Call('gpuR_cpp_gpuR_qr', PACKAGE = 'gpuR', ptrA, isVCL, type_flag, ctx_id)
}

cpp_recover_qr <- function(ptrQR, QRisVCL, ptrQ, QisVCL, ptrR, RisVCL, betas, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_recover_qr', PACKAGE = 'gpuR', ptrQR, QRisVCL, ptrQ, QisVCL, ptrR, RisVCL, betas, type_flag, ctx_id))
}

cpp_gpuMatrix_pmcc <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_pmcc', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_vclMatrix_pmcc <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_vclMatrix_pmcc', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_vclMatrix_eucl <- function(ptrA, ptrD, squareDist, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_vclMatrix_eucl', PACKAGE = 'gpuR', ptrA, ptrD, squareDist, type_flag, ctx_id))
}

cpp_vclMatrix_peucl <- function(ptrA, ptrB, ptrD, squareDist, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_vclMatrix_peucl', PACKAGE = 'gpuR', ptrA, ptrB, ptrD, squareDist, type_flag, ctx_id))
}

cpp_gpuMatrix_eucl <- function(ptrA, ptrD, squareDist, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_eucl', PACKAGE = 'gpuR', ptrA, ptrD, squareDist, type_flag, ctx_id))
}

cpp_gpuMatrix_peucl <- function(ptrA, ptrB, ptrD, squareDist, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_peucl', PACKAGE = 'gpuR', ptrA, ptrB, ptrD, squareDist, type_flag, ctx_id))
}

cpp_gpuMatrix_colmean <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_colmean', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuMatrix_colsum <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_colsum', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuMatrix_rowmean <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_rowmean', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_gpuMatrix_rowsum <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_rowsum', PACKAGE = 'gpuR', ptrA, ptrB, type_flag, ctx_id))
}

cpp_vclMatrix_colmean <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_colmean', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclMatrix_colsum <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_colsum', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclMatrix_rowmean <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_rowmean', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclMatrix_rowsum <- function(ptrA, ptrB, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_rowsum', PACKAGE = 'gpuR', ptrA, ptrB, type_flag))
}

cpp_vclMatrix_svd <- function(ptrA, ptrD, ptrU, ptrV, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_vclMatrix_svd', PACKAGE = 'gpuR', ptrA, ptrD, ptrU, ptrV, type_flag, ctx_id))
}

cpp_gpuMatrix_svd <- function(ptrA, ptrD, ptrU, ptrV, type_flag, ctx_id) {
    invisible(.Call('gpuR_cpp_gpuMatrix_svd', PACKAGE = 'gpuR', ptrA, ptrD, ptrU, ptrV, type_flag, ctx_id))
}

