# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

cpp_vclMatrix_custom_chol <- function(ptrB, BisVCL, upper, sourceCode, max_local_size, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_vclMatrix_custom_chol`, ptrB, BisVCL, upper, sourceCode, max_local_size, type_flag, ctx_id))
}

initContexts <- function() {
    .Call(`_gpuR_initContexts`)
}

#' @title Available OpenCL Contexts
#' @description Provide a data.frame of available OpenCL contexts and
#' associated information.
#' @return data.frame containing the following fields
#' @return \item{context}{Integer identifying context}
#' @return \item{platform}{Character string listing OpenCL platform}
#' @return \item{platform_index}{Integer identifying platform}
#' @return \item{device}{Character string listing device name}
#' @return \item{device_index}{Integer identifying device}
#' @return \item{device_type}{Character string labeling device (e.g. gpu)}
#' @export
listContexts <- function() {
    .Call(`_gpuR_listContexts`)
}

#' @title Current Context
#' @description Get current context index
#' @return An integer reflecting the context listed in \link{listContexts}
#' @export
currentContext <- function() {
    .Call(`_gpuR_currentContext`)
}

cpp_setContext <- function(id) {
    invisible(.Call(`_gpuR_cpp_setContext`, id))
}

getContextPtr <- function(ctx_id) {
    .Call(`_gpuR_getContextPtr`, ctx_id)
}

cpp_vclMatrix_sign <- function(ptrA, AisVCL, ptrB, BisVCL, sourceCode, max_local_size, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_vclMatrix_sign`, ptrA, AisVCL, ptrB, BisVCL, sourceCode, max_local_size, type_flag, ctx_id))
}

cpp_vclVector_sign <- function(ptrA, AisVCL, ptrB, BisVCL, sourceCode, max_local_size, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_vclVector_sign`, ptrA, AisVCL, ptrB, BisVCL, sourceCode, max_local_size, type_flag, ctx_id))
}

cpp_vclMatrix_pmax <- function(ptrA, AisVCL, ptrB, BisVCL, value, sourceCode, max_local_size, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_vclMatrix_pmax`, ptrA, AisVCL, ptrB, BisVCL, value, sourceCode, max_local_size, type_flag, ctx_id))
}

cpp_vclVector_pmax <- function(ptrA, AisVCL, ptrB, BisVCL, value, sourceCode, max_local_size, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_vclVector_pmax`, ptrA, AisVCL, ptrB, BisVCL, value, sourceCode, max_local_size, type_flag, ctx_id))
}

cpp_deviceType <- function(gpu_idx_, ctx_idx) {
    .Call(`_gpuR_cpp_deviceType`, gpu_idx_, ctx_idx)
}

cpp_detectGPUs <- function(platform_idx) {
    .Call(`_gpuR_cpp_detectGPUs`, platform_idx)
}

cpp_gpuInfo <- function(gpu_idx_, ctx_idx) {
    .Call(`_gpuR_cpp_gpuInfo`, gpu_idx_, ctx_idx)
}

cpp_cpuInfo <- function(cpu_idx_, ctx_idx) {
    .Call(`_gpuR_cpp_cpuInfo`, cpu_idx_, ctx_idx)
}

#' @title Current Device Information
#' @description Check current device information
#' @return list containing
#' @return \item{device}{Character string of device name}
#' @return \item{device_index}{Integer identifying device}
#' @return \item{device_type}{Character string identifying device type (e.g. gpu)}
#' @export
currentDevice <- function() {
    .Call(`_gpuR_currentDevice`)
}

cpp_detectCPUs <- function(platform_idx) {
    .Call(`_gpuR_cpp_detectCPUs`, platform_idx)
}

preferred_wg_size <- function(sourceCode_, kernel_name, ctx_id) {
    .Call(`_gpuR_preferred_wg_size`, sourceCode_, kernel_name, ctx_id)
}

cpp_deepcopy_gpuMatrix <- function(ptrA, type_flag) {
    .Call(`_gpuR_cpp_deepcopy_gpuMatrix`, ptrA, type_flag)
}

cpp_cbind_gpuMatrix <- function(ptrA, ptrB, type_flag) {
    .Call(`_gpuR_cpp_cbind_gpuMatrix`, ptrA, ptrB, type_flag)
}

cpp_rbind_gpuMatrix <- function(ptrA, ptrB, type_flag) {
    .Call(`_gpuR_cpp_rbind_gpuMatrix`, ptrA, ptrB, type_flag)
}

cpp_deepcopy_gpuVector <- function(ptrA, type_flag) {
    .Call(`_gpuR_cpp_deepcopy_gpuVector`, ptrA, type_flag)
}

sliceGPUvec <- function(ptrA, start, end, type_flag) {
    .Call(`_gpuR_sliceGPUvec`, ptrA, start, end, type_flag)
}

gpuMatBlock <- function(ptrA, rowStart, rowEnd, colStart, colEnd, type_flag) {
    .Call(`_gpuR_gpuMatBlock`, ptrA, rowStart, rowEnd, colStart, colEnd, type_flag)
}

GetVecElement <- function(ptrA, idx, type_flag) {
    .Call(`_gpuR_GetVecElement`, ptrA, idx, type_flag)
}

SetVecElement <- function(ptrA, idx, value, type_flag) {
    invisible(.Call(`_gpuR_SetVecElement`, ptrA, idx, value, type_flag))
}

SetMatRow <- function(ptrA, idx, value, type_flag) {
    invisible(.Call(`_gpuR_SetMatRow`, ptrA, idx, value, type_flag))
}

SetMatCol <- function(ptrA, idx, value, type_flag) {
    invisible(.Call(`_gpuR_SetMatCol`, ptrA, idx, value, type_flag))
}

SetMatElement <- function(ptrA, nr, nc, value, type_flag) {
    invisible(.Call(`_gpuR_SetMatElement`, ptrA, nr, nc, value, type_flag))
}

GetMatRow <- function(ptrA, idx, type_flag) {
    .Call(`_gpuR_GetMatRow`, ptrA, idx, type_flag)
}

GetMatCol <- function(ptrA, idx, type_flag) {
    .Call(`_gpuR_GetMatCol`, ptrA, idx, type_flag)
}

GetMatElement <- function(ptrA, nr, nc, type_flag) {
    .Call(`_gpuR_GetMatElement`, ptrA, nr, nc, type_flag)
}

sexpVecToEigenVecXptr <- function(ptrA, size, type_flag) {
    .Call(`_gpuR_sexpVecToEigenVecXptr`, ptrA, size, type_flag)
}

cpp_scalar_gpuVector <- function(scalar, size, type_flag) {
    .Call(`_gpuR_cpp_scalar_gpuVector`, scalar, size, type_flag)
}

sexpVecToEigenXptr <- function(ptrA, nr, nc, type_flag, ctx_id) {
    .Call(`_gpuR_sexpVecToEigenXptr`, ptrA, nr, nc, type_flag, ctx_id)
}

initScalarEigenXptr <- function(scalar, nr, nc, type_flag, ctx_id) {
    .Call(`_gpuR_initScalarEigenXptr`, scalar, nr, nc, type_flag, ctx_id)
}

getRmatEigenAddress <- function(ptrA, nr, nc, type_flag, ctx_id) {
    .Call(`_gpuR_getRmatEigenAddress`, ptrA, nr, nc, type_flag, ctx_id)
}

getEigenMatrix <- function(ptrA, type_flag) {
    .Call(`_gpuR_getEigenMatrix`, ptrA, type_flag)
}

MatXptrToMatSEXP <- function(ptrA, type_flag) {
    .Call(`_gpuR_MatXptrToMatSEXP`, ptrA, type_flag)
}

emptyEigenVecXptr <- function(size, type_flag) {
    .Call(`_gpuR_emptyEigenVecXptr`, size, type_flag)
}

emptyEigenXptr <- function(nr, nc, type_flag, ctx_id) {
    .Call(`_gpuR_emptyEigenXptr`, nr, nc, type_flag, ctx_id)
}

setCols <- function(ptrA, names, type_flag) {
    invisible(.Call(`_gpuR_setCols`, ptrA, names, type_flag))
}

getCols <- function(ptrA, type_flag) {
    .Call(`_gpuR_getCols`, ptrA, type_flag)
}

cpp_gpuMatrix_get_diag <- function(ptrA, ptrB, type_flag) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_get_diag`, ptrA, ptrB, type_flag))
}

cpp_gpuMat_gpuVec_set_diag <- function(ptrA, ptrB, type_flag) {
    invisible(.Call(`_gpuR_cpp_gpuMat_gpuVec_set_diag`, ptrA, ptrB, type_flag))
}

cpp_gpuMatrix_custom_igemm <- function(ptrA_, AisVCL, ptrB_, BisVCL, ptrC_, CisVCL, sourceCode_, max_local_size, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_custom_igemm`, ptrA_, AisVCL, ptrB_, BisVCL, ptrC_, CisVCL, sourceCode_, max_local_size, ctx_id))
}

cpp_vclMatrix_norm <- function(ptrA, method, type_flag) {
    .Call(`_gpuR_cpp_vclMatrix_norm`, ptrA, method, type_flag)
}

cpp_gpuMatrix_norm <- function(ptrA, method, type_flag) {
    .Call(`_gpuR_cpp_gpuMatrix_norm`, ptrA, method, type_flag)
}

#' @title Detect Number of Platforms
#' @description Find out how many OpenCL enabled platforms are available.
#' @return An integer value representing the number of platforms available.
#' @seealso \link{detectGPUs}
#' @export
detectPlatforms <- function() {
    .Call(`_gpuR_detectPlatforms`)
}

#' @title Return Current Platform
#' @description Find out which platform is currently in use
#' @return \item{platform}{Name of the current platform}
#' @return \item{platform_index}{Index of current platform}
#' @seealso \link{detectPlatforms}
#' @export
currentPlatform <- function() {
    .Call(`_gpuR_currentPlatform`)
}

cpp_platformInfo <- function(platform_idx_) {
    .Call(`_gpuR_cpp_platformInfo`, platform_idx_)
}

cpp_vclVector_permute <- function(ptrA, indices, sourceCode, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_vclVector_permute`, ptrA, indices, sourceCode, type_flag, ctx_id))
}

cpp_vclMatrix_set_row_order <- function(ptrA, AisVCL, indices, sourceCode, max_local_size, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_vclMatrix_set_row_order`, ptrA, AisVCL, indices, sourceCode, max_local_size, type_flag, ctx_id))
}

cpp_gpuMatrix_det <- function(ptrA, AisVCL, type_flag, ctx_id) {
    .Call(`_gpuR_cpp_gpuMatrix_det`, ptrA, AisVCL, type_flag, ctx_id)
}

cpp_gpuMatrix_solve <- function(ptrA, ptrB, AisVCL, BisVCL, type_flag, ctx_id, BisI = TRUE) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_solve`, ptrA, ptrB, AisVCL, BisVCL, type_flag, ctx_id, BisI))
}

#' @title Synchronize Device Execution
#' @description This pauses execution until the processing is complete
#' on the device (CPU/GPU/etc.).  This is important especially for
#' benchmarking applications.
#' @return NULL
#' @author Charles Determan Jr.
#' @examples \dontrun{
#'     mat <- vclMatrix(rnorm(500^2), ncol = 500, nrow = 500)
#'     system.time({mat %*% mat})
#'     system.time({mat %*% mat; synchronize()})
#' }
#' @export
synchronize <- function() {
    invisible(.Call(`_gpuR_synchronize`))
}

truncIntgpuMat <- function(ptrA_, nr, nc) {
    .Call(`_gpuR_truncIntgpuMat`, ptrA_, nr, nc)
}

truncFloatgpuMat <- function(ptrA_, nr, nc) {
    .Call(`_gpuR_truncFloatgpuMat`, ptrA_, nr, nc)
}

truncDoublegpuMat <- function(ptrA_, nr, nc) {
    .Call(`_gpuR_truncDoublegpuMat`, ptrA_, nr, nc)
}

cpp_vcl_nrow <- function(ptrA, type_flag) {
    .Call(`_gpuR_cpp_vcl_nrow`, ptrA, type_flag)
}

cpp_vcl_ncol <- function(ptrA, type_flag) {
    .Call(`_gpuR_cpp_vcl_ncol`, ptrA, type_flag)
}

cpp_vclVector_size <- function(ptrA, type_flag) {
    .Call(`_gpuR_cpp_vclVector_size`, ptrA, type_flag)
}

cpp_gpuVector_size <- function(ptrA, type_flag) {
    .Call(`_gpuR_cpp_gpuVector_size`, ptrA, type_flag)
}

cpp_gpuVector_max <- function(ptrA, type_flag, ctx_id) {
    .Call(`_gpuR_cpp_gpuVector_max`, ptrA, type_flag, ctx_id)
}

cpp_gpuMatrix_max <- function(ptrA, type_flag) {
    .Call(`_gpuR_cpp_gpuMatrix_max`, ptrA, type_flag)
}

cpp_gpuMatrix_min <- function(ptrA, type_flag) {
    .Call(`_gpuR_cpp_gpuMatrix_min`, ptrA, type_flag)
}

cpp_gpuMatrix_nrow <- function(ptrA, type_flag) {
    .Call(`_gpuR_cpp_gpuMatrix_nrow`, ptrA, type_flag)
}

cpp_gpuMatrix_ncol <- function(ptrA, type_flag) {
    .Call(`_gpuR_cpp_gpuMatrix_ncol`, ptrA, type_flag)
}

cpp_identity_vclMatrix <- function(ptrA, type_flag) {
    invisible(.Call(`_gpuR_cpp_identity_vclMatrix`, ptrA, type_flag))
}

cpp_vclMatrix_get_diag <- function(ptrA, ptrB, type_flag) {
    invisible(.Call(`_gpuR_cpp_vclMatrix_get_diag`, ptrA, ptrB, type_flag))
}

cpp_vclMat_vclVec_set_diag <- function(ptrA, ptrB, type_flag) {
    invisible(.Call(`_gpuR_cpp_vclMat_vclVec_set_diag`, ptrA, ptrB, type_flag))
}

cpp_deepcopy_vclMatrix <- function(ptrA, type_flag, ctx_id, source) {
    .Call(`_gpuR_cpp_deepcopy_vclMatrix`, ptrA, type_flag, ctx_id, source)
}

cpp_deepcopy_vclVector <- function(ptrA, type_flag, ctx_id) {
    .Call(`_gpuR_cpp_deepcopy_vclVector`, ptrA, type_flag, ctx_id)
}

cpp_vclVector_slice <- function(ptrA, start, end, type_flag) {
    .Call(`_gpuR_cpp_vclVector_slice`, ptrA, start, end, type_flag)
}

cpp_vclMatrix_block <- function(ptrA, rowStart, rowEnd, colStart, colEnd, type_flag) {
    .Call(`_gpuR_cpp_vclMatrix_block`, ptrA, rowStart, rowEnd, colStart, colEnd, type_flag)
}

cpp_cbind_vclMatrix <- function(ptrA, ptrB, ptrC, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_cbind_vclMatrix`, ptrA, ptrB, ptrC, type_flag, ctx_id))
}

cpp_cbind_vclMat_vclVec <- function(ptrA, ptrB, ptrC, order, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_cbind_vclMat_vclVec`, ptrA, ptrB, ptrC, order, type_flag, ctx_id))
}

cpp_rbind_vclMatrix <- function(ptrA, ptrB, type_flag, ctx_id) {
    .Call(`_gpuR_cpp_rbind_vclMatrix`, ptrA, ptrB, type_flag, ctx_id)
}

cpp_sexp_mat_to_vclMatrix <- function(ptrA, type_flag, ctx_id) {
    .Call(`_gpuR_cpp_sexp_mat_to_vclMatrix`, ptrA, type_flag, ctx_id)
}

VCLtoMatSEXP <- function(ptrA, type_flag) {
    .Call(`_gpuR_VCLtoMatSEXP`, ptrA, type_flag)
}

cpp_zero_vclMatrix <- function(nr, nc, type_flag, ctx_id) {
    .Call(`_gpuR_cpp_zero_vclMatrix`, nr, nc, type_flag, ctx_id)
}

cpp_scalar_vclMatrix <- function(scalar, nr, nc, type_flag, ctx_id) {
    .Call(`_gpuR_cpp_scalar_vclMatrix`, scalar, nr, nc, type_flag, ctx_id)
}

vclSetCol <- function(ptrA, nc, newdata, type_flag) {
    invisible(.Call(`_gpuR_vclSetCol`, ptrA, nc, newdata, type_flag))
}

vclFillCol <- function(ptrA, nc, newdata, ctx_id, type_flag) {
    invisible(.Call(`_gpuR_vclFillCol`, ptrA, nc, newdata, ctx_id, type_flag))
}

vclSetRow <- function(ptrA, nr, newdata, type_flag) {
    invisible(.Call(`_gpuR_vclSetRow`, ptrA, nr, newdata, type_flag))
}

vclSetElement <- function(ptrA, nr, nc, newdata, type_flag) {
    invisible(.Call(`_gpuR_vclSetElement`, ptrA, nr, nc, newdata, type_flag))
}

vclSetMatrix <- function(ptrA, newdata, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_vclSetMatrix`, ptrA, newdata, type_flag, ctx_id))
}

vclSetVCLMatrix <- function(ptrA, newdata, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_vclSetVCLMatrix`, ptrA, newdata, type_flag, ctx_id))
}

vclMatSetVCLCols <- function(ptrA, newdata, start, end, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_vclMatSetVCLCols`, ptrA, newdata, start, end, type_flag, ctx_id))
}

vclFillVCLMatrix <- function(ptrA, newdata, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_vclFillVCLMatrix`, ptrA, newdata, type_flag, ctx_id))
}

vclGetCol <- function(ptrA, nc, type_flag, ctx_id) {
    .Call(`_gpuR_vclGetCol`, ptrA, nc, type_flag, ctx_id)
}

vclGetRow <- function(ptrA, nr, type_flag, ctx_id) {
    .Call(`_gpuR_vclGetRow`, ptrA, nr, type_flag, ctx_id)
}

extractRow <- function(ptrA, row_idx, type_flag, ctx_id) {
    .Call(`_gpuR_extractRow`, ptrA, row_idx, type_flag, ctx_id)
}

extractCol <- function(ptrA, col_idx, type_flag, ctx_id) {
    .Call(`_gpuR_extractCol`, ptrA, col_idx, type_flag, ctx_id)
}

vclGetElement <- function(ptrA, nr, nc, type_flag) {
    .Call(`_gpuR_vclGetElement`, ptrA, nr, nc, type_flag)
}

vclVecGetElement <- function(ptrA, idx, type_flag) {
    .Call(`_gpuR_vclVecGetElement`, ptrA, idx, type_flag)
}

vclVecSetElement <- function(ptrA, idx, newdata, type_flag) {
    invisible(.Call(`_gpuR_vclVecSetElement`, ptrA, idx, newdata, type_flag))
}

vclSetVector <- function(ptrA, newdata, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_vclSetVector`, ptrA, newdata, type_flag, ctx_id))
}

vclFillVectorScalar <- function(ptrA, newdata, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_vclFillVectorScalar`, ptrA, newdata, type_flag, ctx_id))
}

vclFillVectorRangeScalar <- function(ptrA, newdata, start, end, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_vclFillVectorRangeScalar`, ptrA, newdata, start, end, type_flag, ctx_id))
}

vclFillVectorSliceScalar <- function(ptrA, newdata, start, stride, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_vclFillVectorSliceScalar`, ptrA, newdata, start, stride, type_flag, ctx_id))
}

vclFillVectorElementwise <- function(ptrA, newdata, start, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_vclFillVectorElementwise`, ptrA, newdata, start, type_flag, ctx_id))
}

vclSetVCLVector <- function(ptrA, newdata, type_flag) {
    invisible(.Call(`_gpuR_vclSetVCLVector`, ptrA, newdata, type_flag))
}

vclSetVCLVectorRange <- function(ptrA, newdata, start, end, type_flag) {
    invisible(.Call(`_gpuR_vclSetVCLVectorRange`, ptrA, newdata, start, end, type_flag))
}

vclVecSetVCLMatrix <- function(ptrA, newdata, type_flag) {
    invisible(.Call(`_gpuR_vclVecSetVCLMatrix`, ptrA, newdata, type_flag))
}

vclSetVCLMatrixRange <- function(ptrA, newdata, start, end, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_vclSetVCLMatrixRange`, ptrA, newdata, start, end, type_flag, ctx_id))
}

vectorToVCL <- function(ptrA, type_flag, ctx_id) {
    .Call(`_gpuR_vectorToVCL`, ptrA, type_flag, ctx_id)
}

vectorToMatVCL <- function(ptrA, nr, nc, type_flag, ctx_id) {
    .Call(`_gpuR_vectorToMatVCL`, ptrA, nr, nc, type_flag, ctx_id)
}

vclMatTovclVec <- function(ptrA, shared, ctx_id, type_flag) {
    .Call(`_gpuR_vclMatTovclVec`, ptrA, shared, ctx_id, type_flag)
}

cpp_scalar_vclVector <- function(scalar, size, type_flag, ctx_id) {
    .Call(`_gpuR_cpp_scalar_vclVector`, scalar, size, type_flag, ctx_id)
}

VCLtoVecSEXP <- function(ptrA, type_flag) {
    .Call(`_gpuR_VCLtoVecSEXP`, ptrA, type_flag)
}

emptyVecVCL <- function(length, type_flag, ctx_id) {
    .Call(`_gpuR_emptyVecVCL`, length, type_flag, ctx_id)
}

setVCLcols <- function(ptrA, names, type_flag) {
    invisible(.Call(`_gpuR_setVCLcols`, ptrA, names, type_flag))
}

getVCLcols <- function(ptrA, type_flag) {
    .Call(`_gpuR_getVCLcols`, ptrA, type_flag)
}

vectorizeList <- function(mylist, ptrV, ctx_id, type_flag) {
    invisible(.Call(`_gpuR_vectorizeList`, mylist, ptrV, ctx_id, type_flag))
}

assignVectorToMat <- function(ptrM, ptrV, type_flag) {
    invisible(.Call(`_gpuR_assignVectorToMat`, ptrM, ptrV, type_flag))
}

assignVectorToCol <- function(ptrM, ptrV, index, type_flag) {
    invisible(.Call(`_gpuR_assignVectorToCol`, ptrM, ptrV, index, type_flag))
}

cpp_gpuMatrix_elem_prod <- function(ptrA, AisVCL, ptrB, BisVCL, ptrC, CisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_elem_prod`, ptrA, AisVCL, ptrB, BisVCL, ptrC, CisVCL, type_flag, ctx_id))
}

cpp_gpuMatrix_scalar_prod <- function(ptrC, CisVCL, scalar, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_scalar_prod`, ptrC, CisVCL, scalar, type_flag, ctx_id))
}

cpp_gpuMatrix_scalar_div <- function(ptrC, CisVCL, B_scalar, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_scalar_div`, ptrC, CisVCL, B_scalar, type_flag, ctx_id))
}

cpp_gpuMatrix_scalar_div_2 <- function(ptrC, CisVCL, scalar, max_local_size, sourceCode_, ctx_id, type_flag) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_scalar_div_2`, ptrC, CisVCL, scalar, max_local_size, sourceCode_, ctx_id, type_flag))
}

cpp_gpuMatrix_elem_div <- function(ptrA, AisVCL, ptrB, BisVCL, ptrC, CisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_elem_div`, ptrA, AisVCL, ptrB, BisVCL, ptrC, CisVCL, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_pow <- function(ptrA, AisVCL, ptrB, BisVCL, ptrC, CisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_elem_pow`, ptrA, AisVCL, ptrB, BisVCL, ptrC, CisVCL, type_flag, ctx_id))
}

cpp_gpuMatrix_scalar_pow <- function(ptrA, AisVCL, scalar, ptrC, CisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_scalar_pow`, ptrA, AisVCL, scalar, ptrC, CisVCL, type_flag, ctx_id))
}

cpp_gpuMatrix_sqrt <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_sqrt`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_sin <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_elem_sin`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_asin <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_elem_asin`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_sinh <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_elem_sinh`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_cos <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_elem_cos`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_acos <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_elem_acos`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_cosh <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_elem_cosh`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_tan <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_elem_tan`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_atan <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_elem_atan`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_tanh <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_elem_tanh`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_log <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_elem_log`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_log_base <- function(ptrA, AisVCL, ptrB, BisVCL, base, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_elem_log_base`, ptrA, AisVCL, ptrB, BisVCL, base, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_log10 <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_elem_log10`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_exp <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_elem_exp`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuMatrix_elem_abs <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_elem_abs`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuMatrix_axpy <- function(alpha, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_axpy`, alpha, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuMatrix_unary_axpy <- function(ptrA, AisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_unary_axpy`, ptrA, AisVCL, type_flag, ctx_id))
}

cpp_gpuMatrix_scalar_axpy <- function(alpha, scalar, ptrB, BisVCL, order, max_local_size, sourceCode, ctx_id, type_flag) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_scalar_axpy`, alpha, scalar, ptrB, BisVCL, order, max_local_size, sourceCode, ctx_id, type_flag))
}

cpp_vclMatrix_max <- function(ptrA, type_flag) {
    .Call(`_gpuR_cpp_vclMatrix_max`, ptrA, type_flag)
}

cpp_vclMatrix_min <- function(ptrA, type_flag) {
    .Call(`_gpuR_cpp_vclMatrix_min`, ptrA, type_flag)
}

cpp_gpuVector_axpy <- function(alpha, ptrA, AisVCL, ptrB, BisVCL, order, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_axpy`, alpha, ptrA, AisVCL, ptrB, BisVCL, order, type_flag, ctx_id))
}

cpp_gpuVector_unary_axpy <- function(ptrA, AisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_unary_axpy`, ptrA, AisVCL, type_flag, ctx_id))
}

cpp_gpuVector_inner_prod <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    .Call(`_gpuR_cpp_gpuVector_inner_prod`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id)
}

cpp_gpuVector_outer_prod <- function(ptrA, AisVCL, ptrB, BisVCL, ptrC, CisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_outer_prod`, ptrA, AisVCL, ptrB, BisVCL, ptrC, CisVCL, type_flag, ctx_id))
}

cpp_gpuVector_elem_prod <- function(ptrA, AisVCL, ptrB, BisVCL, ptrC, CisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_elem_prod`, ptrA, AisVCL, ptrB, BisVCL, ptrC, CisVCL, type_flag, ctx_id))
}

cpp_gpuVector_scalar_prod <- function(ptrC, CisVCL, scalar, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_scalar_prod`, ptrC, CisVCL, scalar, type_flag, ctx_id))
}

cpp_gpuVector_elem_div <- function(ptrA, AisVCL, ptrB, BisVCL, ptrC, CisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_elem_div`, ptrA, AisVCL, ptrB, BisVCL, ptrC, CisVCL, type_flag, ctx_id))
}

cpp_gpuVector_scalar_div <- function(ptrC, CisVCL, scalar, order, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_scalar_div`, ptrC, CisVCL, scalar, order, type_flag, ctx_id))
}

cpp_gpuVector_elem_pow <- function(ptrA, AisVCL, ptrB, BisVCL, ptrC, CisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_elem_pow`, ptrA, AisVCL, ptrB, BisVCL, ptrC, CisVCL, type_flag, ctx_id))
}

cpp_gpuVector_scalar_pow <- function(ptrA, AisVCL, scalar, ptrC, CisVCL, order, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_scalar_pow`, ptrA, AisVCL, scalar, ptrC, CisVCL, order, type_flag, ctx_id))
}

cpp_gpuVector_sqrt <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_sqrt`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuVector_elem_sin <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_elem_sin`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuVector_elem_asin <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_elem_asin`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuVector_elem_sinh <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_elem_sinh`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuVector_elem_cos <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_elem_cos`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuVector_elem_acos <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_elem_acos`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuVector_elem_cosh <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_elem_cosh`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuVector_elem_tan <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_elem_tan`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuVector_elem_atan <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_elem_atan`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuVector_elem_tanh <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_elem_tanh`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuVector_elem_log10 <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_elem_log10`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuVector_elem_log <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_elem_log`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuVector_elem_log_base <- function(ptrA, AisVCL, ptrB, BisVCL, base, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_elem_log_base`, ptrA, AisVCL, ptrB, BisVCL, base, type_flag, ctx_id))
}

cpp_gpuVector_elem_exp <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_elem_exp`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuVector_elem_abs <- function(ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_gpuVector_elem_abs`, ptrA, AisVCL, ptrB, BisVCL, type_flag, ctx_id))
}

cpp_gpuVector_min <- function(ptrA, type_flag, ctx_id) {
    .Call(`_gpuR_cpp_gpuVector_min`, ptrA, type_flag, ctx_id)
}

cpp_vclVector_max <- function(ptrA, type_flag) {
    .Call(`_gpuR_cpp_vclVector_max`, ptrA, type_flag)
}

cpp_vclVector_elem_max_abs <- function(ptrA, type_flag) {
    .Call(`_gpuR_cpp_vclVector_elem_max_abs`, ptrA, type_flag)
}

cpp_vclVector_min <- function(ptrA, type_flag) {
    .Call(`_gpuR_cpp_vclVector_min`, ptrA, type_flag)
}

cpp_gpuMatrix_gemv <- function(ptrA, AisVCL, ptrB, BisVCL, ptrC, CisVCL, ctx_id, type_flag) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_gemv`, ptrA, AisVCL, ptrB, BisVCL, ptrC, CisVCL, ctx_id, type_flag))
}

cpp_gpuMatrix_gevm <- function(ptrA, AisVCL, ptrB, BisVCL, ptrC, CisVCL, ctx_id, type_flag) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_gevm`, ptrA, AisVCL, ptrB, BisVCL, ptrC, CisVCL, ctx_id, type_flag))
}

cpp_vclMatVec_crossprod <- function(ptrA, AisVec, ptrB, BisVec, ptrC, type_flag) {
    invisible(.Call(`_gpuR_cpp_vclMatVec_crossprod`, ptrA, AisVec, ptrB, BisVec, ptrC, type_flag))
}

cpp_vclMatVec_tcrossprod <- function(ptrA, AisVec, ptrB, BisVec, ptrC, CisVec, type_flag) {
    invisible(.Call(`_gpuR_cpp_vclMatVec_tcrossprod`, ptrA, AisVec, ptrB, BisVec, ptrC, CisVec, type_flag))
}

cpp_vclMatVec_axpy <- function(alpha, ptrA, AisVec, ptrB, BisVec, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_vclMatVec_axpy`, alpha, ptrA, AisVec, ptrB, BisVec, type_flag, ctx_id))
}

cpp_gpuMatrix_gemm <- function(ptrA, ptrB, ptrC, type_flag) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_gemm`, ptrA, ptrB, ptrC, type_flag))
}

cpp_gpuMatrix_crossprod <- function(ptrA, ptrB, ptrC, type_flag) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_crossprod`, ptrA, ptrB, ptrC, type_flag))
}

cpp_gpuMatrix_tcrossprod <- function(ptrA, ptrB, ptrC, type_flag) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_tcrossprod`, ptrA, ptrB, ptrC, type_flag))
}

cpp_gpuMatrix_transpose <- function(ptrA, ptrB, type_flag) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_transpose`, ptrA, ptrB, type_flag))
}

cpp_vclMatrix_gemm <- function(ptrA, ptrB, ptrC, type_flag) {
    invisible(.Call(`_gpuR_cpp_vclMatrix_gemm`, ptrA, ptrB, ptrC, type_flag))
}

cpp_vclMatrix_crossprod <- function(ptrA, ptrB, ptrC, type_flag) {
    invisible(.Call(`_gpuR_cpp_vclMatrix_crossprod`, ptrA, ptrB, ptrC, type_flag))
}

cpp_vclMat_vclVec_crossprod <- function(ptrA, ptrB, ptrC, type_flag) {
    invisible(.Call(`_gpuR_cpp_vclMat_vclVec_crossprod`, ptrA, ptrB, ptrC, type_flag))
}

cpp_vclMatrix_tcrossprod <- function(ptrA, ptrB, ptrC, type_flag) {
    invisible(.Call(`_gpuR_cpp_vclMatrix_tcrossprod`, ptrA, ptrB, ptrC, type_flag))
}

cpp_vclMatrix_transpose <- function(ptrA, ptrB, type_flag) {
    invisible(.Call(`_gpuR_cpp_vclMatrix_transpose`, ptrA, ptrB, type_flag))
}

cpp_gpu_eigen <- function(Am, Qm, eigenvalues, symmetric, type_flag) {
    invisible(.Call(`_gpuR_cpp_gpu_eigen`, Am, Qm, eigenvalues, symmetric, type_flag))
}

cpp_vcl_eigen <- function(Am, Qm, eigenvalues, symmetric, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_vcl_eigen`, Am, Qm, eigenvalues, symmetric, type_flag, ctx_id))
}

cpp_gpuR_qr <- function(ptrA, isVCL, type_flag, ctx_id) {
    .Call(`_gpuR_cpp_gpuR_qr`, ptrA, isVCL, type_flag, ctx_id)
}

cpp_recover_qr <- function(ptrQR, QRisVCL, ptrQ, QisVCL, ptrR, RisVCL, betas, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_recover_qr`, ptrQR, QRisVCL, ptrQ, QisVCL, ptrR, RisVCL, betas, type_flag, ctx_id))
}

cpp_gpuMatrix_pmcc <- function(ptrA, ptrB, type_flag) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_pmcc`, ptrA, ptrB, type_flag))
}

cpp_gpuMatrix_pmcc2 <- function(ptrA, ptrB, ptrC, type_flag) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_pmcc2`, ptrA, ptrB, ptrC, type_flag))
}

cpp_vclMatrix_pmcc <- function(ptrA, ptrB, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_vclMatrix_pmcc`, ptrA, ptrB, type_flag, ctx_id))
}

cpp_vclMatrix_pmcc2 <- function(ptrA, ptrB, ptrC, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_vclMatrix_pmcc2`, ptrA, ptrB, ptrC, type_flag, ctx_id))
}

cpp_vclMatrix_eucl <- function(ptrA, ptrD, squareDist, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_vclMatrix_eucl`, ptrA, ptrD, squareDist, type_flag, ctx_id))
}

cpp_vclMatrix_peucl <- function(ptrA, ptrB, ptrD, squareDist, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_vclMatrix_peucl`, ptrA, ptrB, ptrD, squareDist, type_flag, ctx_id))
}

cpp_gpuMatrix_eucl <- function(ptrA, ptrD, squareDist, type_flag) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_eucl`, ptrA, ptrD, squareDist, type_flag))
}

cpp_gpuMatrix_peucl <- function(ptrA, ptrB, ptrD, squareDist, type_flag) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_peucl`, ptrA, ptrB, ptrD, squareDist, type_flag))
}

cpp_gpuMatrix_colmean <- function(ptrA, ptrB, type_flag) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_colmean`, ptrA, ptrB, type_flag))
}

cpp_gpuMatrix_colsum <- function(ptrA, ptrB, type_flag) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_colsum`, ptrA, ptrB, type_flag))
}

cpp_gpuMatrix_rowmean <- function(ptrA, ptrB, type_flag) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_rowmean`, ptrA, ptrB, type_flag))
}

cpp_gpuMatrix_rowsum <- function(ptrA, ptrB, type_flag) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_rowsum`, ptrA, ptrB, type_flag))
}

cpp_gpuMatrix_sum <- function(ptrA, type_flag) {
    .Call(`_gpuR_cpp_gpuMatrix_sum`, ptrA, type_flag)
}

cpp_vclMatrix_colmean <- function(ptrA, ptrB, type_flag) {
    invisible(.Call(`_gpuR_cpp_vclMatrix_colmean`, ptrA, ptrB, type_flag))
}

cpp_vclMatrix_colsum <- function(ptrA, ptrB, type_flag) {
    invisible(.Call(`_gpuR_cpp_vclMatrix_colsum`, ptrA, ptrB, type_flag))
}

cpp_vclMatrix_rowmean <- function(ptrA, ptrB, type_flag) {
    invisible(.Call(`_gpuR_cpp_vclMatrix_rowmean`, ptrA, ptrB, type_flag))
}

cpp_vclMatrix_rowsum <- function(ptrA, ptrB, type_flag) {
    invisible(.Call(`_gpuR_cpp_vclMatrix_rowsum`, ptrA, ptrB, type_flag))
}

cpp_vclMatrix_sum <- function(ptrA, type_flag) {
    .Call(`_gpuR_cpp_vclMatrix_sum`, ptrA, type_flag)
}

cpp_vclMatrix_svd <- function(ptrA, ptrD, ptrU, ptrV, type_flag, ctx_id) {
    invisible(.Call(`_gpuR_cpp_vclMatrix_svd`, ptrA, ptrD, ptrU, ptrV, type_flag, ctx_id))
}

cpp_gpuMatrix_svd <- function(ptrA, ptrD, ptrU, ptrV, type_flag) {
    invisible(.Call(`_gpuR_cpp_gpuMatrix_svd`, ptrA, ptrD, ptrU, ptrV, type_flag))
}

