% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grandR.R
\name{Slots}
\alias{Slots}
\alias{DropSlot}
\alias{AddSlot}
\title{Slot functions}
\usage{
Slots(data)

DropSlot(data, pattern = NULL)

AddSlot(data, name, matrix, set.to.default = FALSE)
}
\arguments{
\item{data}{A grandR object}

\item{pattern}{a regular expression matched against slot names}

\item{name}{the slot name}

\item{matrix}{the data matrix for the new slot}

\item{set.to.default}{set the new slot as the default slot?}
}
\value{
Either the slot names or a grandR data with added/removed slots
}
\description{
Get slot names and add or remove slots
}
\section{Functions}{
\itemize{
\item \code{Slots()}: Obtain the slot names

\item \code{DropSlot()}: Remove one or several slots from this grandR object

\item \code{AddSlot()}: Add an additional slot to this grandR object

}}
\examples{
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=c("Cell",Design$dur.4sU,Design$Replicate))

sars <- Normalize(sars)     # default behavior is to update the default slot
sars
sars <- DropSlot(sars,"norm")
sars                        # note that the defauls slot reverted to count

}
\seealso{
\link{DefaultSlot}
}
\concept{grandr}
