% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure_to_genind.R
\name{structure_to_genind}
\alias{structure_to_genind}
\title{Convert a file in STRUCTURE format into a genind object}
\usage{
structure_to_genind(path, pop_names = NULL, loci_names = NULL,
  ind_names = NULL)
}
\arguments{
\item{path}{A character string indicating the path to the STRUCTURE file in
format .txt, or alternatively the name of the file in the working directory.
The STRUCTURE file must only have :
\itemize{
\item A first column with the IDs of the individuals (can be a simple number)
\item A second column with the IDs of the populations (can be a simple number)
\item Some loci columns : as many columns as loci in the data
}
The row for loci's names is optional but recommended.
Each individual is displayed on 2 rows.}

\item{pop_names}{(optional) A character vector indicating the populations'
names in the same order as in the STRUCTURE file. It is of the same length
as the number of populations. Without this argument, populations are
numbered from 1 to the total number of individuals.}

\item{loci_names}{A character vector with the names of the loci if not
specified in the file's first row. This argument is mandatory if the
STRUCTURE file does not include the names of the loci in the first row.
In other cases, the names of the loci is extracted from the file's first row}

\item{ind_names}{(optional) A character vector indicating the individuals'
names in the same order as in the STRUCTURE file. It is of the same length
as the number of individuals. Without this argument, individuals are
numbered from 1 to the total number of individuals.}
}
\value{
An object of type \code{genind}.
}
\description{
The function converts a text file in STRUCTURE format into
a genind object to use in R
}
\details{
The columns' order of the resulting object can be different from
that of objects returned by \code{\link{gstud_to_genind}}
and \code{\link{genepop_to_genind}}, depending on alleles' and loci's coding
This function uses functions from \pkg{pegas} package.
For details about STRUCTURE file format : \href{http://www.ccg.unam.mx/~vinuesa/tlem09/docs/structure_doc.pdf}{STRUCTURE user manual}
}
\examples{
data("data_pc_genind")
loci_names <- levels(data_pc_genind@loc.fac)
pop_names <- levels(data_pc_genind@pop)
ind_names <- row.names(data_pc_genind@tab)
path_in <- system.file('extdata', 'tab_gstud_structure.txt',
                       package = 'graph4lg')
file_n <- file.path(tempdir(), "tab_gstud_structure.txt")
file.copy(path_in, file_n, overwrite = TRUE)
str <- structure_to_genind(path = file_n, loci_names = loci_names,
                           pop_names = pop_names, ind_names = ind_names)
file.remove(file_n)
}
\author{
P. Savary
}
