% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_cd.R
\name{convert_cd}
\alias{convert_cd}
\title{Fit a model to convert cost-distances into Euclidean distances}
\usage{
convert_cd(
  mat_euc,
  mat_ld,
  to_convert,
  method = "log-log",
  fig = TRUE,
  line_col = "black",
  pts_col = "#999999"
)
}
\arguments{
\item{mat_euc}{A symmetric \code{matrix} with pairwise geographical Euclidean
distances between populations or sample sites. It will be the explanatory
variable, and only values from the off diagonal lower triangle will be used.}

\item{mat_ld}{A symmetric \code{matrix} with pairwise landscape distances
between populations or sample sites. These distances can be
cost-distances or resistance distances, among others.
It will be the explained variable, and only values from the off diagonal
lower triangle will be used.}

\item{to_convert}{A numeric value or numeric vector with Euclidean distances
to convert into cost-distances.}

\item{method}{A character string indicating the method used to fit the model.
\itemize{
\item{If 'method = "log-log"' (default), then the model takes the
following form : log(ld) ~ A + B * log(euc)}
\item{If 'method = "lm"', then the model takes the following form :
ld ~ A + B * euc}
}}

\item{fig}{Logical (default = TRUE) indicating whether a figure is plotted}

\item{line_col}{(if 'fig = TRUE') Character string indicating the color
used to plot the line (default: "blue"). It must be a hexadecimal color
code or a color used by default in R.}

\item{pts_col}{(if 'fig = TRUE') Character string indicating the color
used to plot the points (default: "#999999"). It must be a hexadecimal color
code or a color used by default in R.}
}
\value{
A list of output (converted values, estimated parameters, R2)
and optionally a ggplot2 object to plot
}
\description{
The function fits a model to convert cost-distances into
Euclidean distances as implemented in GRAPHAB software.
}
\details{
IDs in 'mat_euc' and 'mat_ld' must be the same and refer to the same
sampling site or populations, and both matrices must be ordered
in the same way.
Matrix of Euclidean distance 'mat_euc' can be computed using the function
\code{\link{mat_geo_dist}}.
Matrix of landscape distance 'mat_ld' can be computed using
GRAPHAB software.
Before the log calculation, 0 distance values are converted into 1,
so that they are 0 after this calculation.
}
\examples{
data("data_tuto")
mat_ld <- data_tuto[[2]][1:10, 1:10] * 1000
mat_euc <- data_tuto[[1]][1:10, 1:10] * 50000
to_convert <- c(30000, 40000)
res <- convert_cd(mat_euc = mat_euc,
                  mat_ld = mat_ld,
                  to_convert = to_convert, fig = FALSE)
}
\references{
\insertRef{foltete2012software}{graph4lg}
}
\author{
P. Savary
}
