% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNodes.R
\name{getNodes}
\alias{getNodes}
\title{Build node table from edges}
\usage{
getNodes(edges, source = "source", target = "target", ...)
}
\arguments{
\item{edges}{data.frame of edges as typically returned by 
\code{\link{getEdges}}}

\item{source}{Column of source nodes in \code{edges}, must be a 
\code{character} string, defaults to \code{source}.}

\item{target}{Column of target nodes in \code{edges}, must be a 
\code{character} string, required.}

\item{...}{Any other columns to be passed on to the \code{source} nodes - 
will not be applied to \code{target} nodes.}
}
\description{
Get nodes from a data.frame of edges as typically returned by 
\code{\link{getEdges}}
}
\details{
One must keep in mind that nodes need to be unique therefore 
duplicate values (\code{...}) are dropped. Also, the meta-data (\code{...}), 
only applies to the source of edges; NAs are generated for target nodes.
}
\examples{
# simulate dataset
tweets <- data.frame(text = c("I tweet @you about @him", 
                              "I tweet @me about @you"),
                     screenName = c("me", "him"),
                     favorited = c(TRUE, FALSE),
                     stringsAsFactors = FALSE)

# get edges
edges <- getEdges(data = tweets, tweets = "text", source = "screenName", 
                  str.length = NULL, "favorited")

# get nodes
nodes <- getNodes(edges, source = "source", target = "target", 
                  "favorited")

# plot
g <- igraph::graph.data.frame(edges, directed = TRUE, vertices = nodes)
plot(g, vertex.color = igraph::V(g)$favorited)

}
\author{
John Coene \email{jcoenep@gmail.com}
}

