% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchBlocks.R
\name{degreeSort}
\alias{degreeSort}
\title{Sort stochastic block model parameter in a unique way using its graphon}
\usage{
degreeSort(thetaInit, outTheta = TRUE, outPerm = FALSE)
}
\arguments{
\item{thetaInit}{stochastic block model parameter to be sorted}

\item{outTheta}{if TRUE returns the sorted stochastic block model parameter}

\item{outPerm}{if TRUE returns the permutation of the blocks of the
stochastic block model to provide the sorted stochastic block model
parameter}
}
\value{
according to the values of outTheta and outPerm the function returns
the sorted stochastic block model parameter or the associated permutation of
the blocks of the stochastic block model or a list with both of them
}
\description{
Sort stochastic block model parameter in a unique way using its graphon
}
\examples{
theta1 <- list(pi=c(.5,.5), gamma=matrix((1:4)/8,2,2))
degreeSort(theta1)
theta2 <- list(pi=c(.5,.5), gamma=matrix(4:1/8,2,2))
degreeSort(theta2)
}
